#include <windows.h>
#include <malloc.h>

unsigned short SwapSHORT(unsigned short x);

#define MIDI_NOTEOFF	((BYTE)0x80)
#define MIDI_NOTEON 	((BYTE)0x90)
#define MIDI_POLYPRESS	((BYTE)0xA0)
#define MIDI_CTRLCHANGE ((BYTE)0xB0)
#define MIDI_PRGMCHANGE ((BYTE)0xC0)
#define MIDI_CHANPRESS	((BYTE)0xD0)
#define MIDI_PITCHBEND	((BYTE)0xE0)

#define MUS_NOTEOFF 	((BYTE)0x00)
#define MUS_NOTEON      ((BYTE)0x10)
#define MUS_PITCHBEND	((BYTE)0x20)
#define MUS_SYSEVENT	((BYTE)0x30)
#define MUS_CTRLCHANGE	((BYTE)0x40)
#define MUS_SCOREEND	((BYTE)0x60)

typedef struct {
    char ID[4];
    WORD scoreLen;
    WORD scoreStart;
    WORD numChans;
    WORD numSecondaryChans;
    WORD numInstruments;
    WORD dummy;
} mushead_t;

BYTE midiHead[] = {
    'M', 'T', 'h', 'd',     // chunk type
    0, 0, 0, 6,             // header length(3̃tB[h̃oCgŁA6)
    0, 0,                   // format 0: only one track
    0, 1,                   // yes, there is really only one track
    0, 70,                  // 70 divisions (f^^C̒Pʂ4701)

    'M', 'T', 'r', 'k',     // chunk type
    0, 0, 0, 0,             // track length(Ōɑ)

    // The first event sets the tempo to 500,000 microsec/quarter note (4̒0.5b)
    0,                      // Xe[^XoCg̑Oɂ͕Kf^^CsȂ΂ȂƎv
    255, 81, 3,             // uWindowsTEhvO~Ov23.6 ^Cxg Q
    0x07, 0xa1, 0x20,       // 500,000

    0,
    0xB9, 7, 127            // Set the percussion channel to full volume
};

BYTE CtrlNumShift[15] = {
    0,                          // 0	program change
    0,                          // 1	bank select
    1,                          // 2	modulation pot
    7,                          // 3	volume
    10,                         // 4	pan pot
    11,                         // 5	expression pot
    91,                         // 6	reverb depth
    93,                         // 7	chorus depth
    64,                         // 8	sustain pedal
    67,                         // 9	soft pedal

    // ȍ~MUSłsystem eventAMIDIł̓`lbZ[W
    120,                        // 10	all sounds off
    123,                        // 11	all notes off
    126,                        // 12	mono
    127,                        // 13	poly
    121,                        // 14	reset all controllers
};

void bwrite(BYTE* src, int count, BYTE** dest)
{
	memcpy(*dest, src, count);
	*dest += count;
}

void bputc(BYTE c, BYTE** dest)
{
	memset(*dest, c, 1);
	(*dest)++;
}

DWORD ReadVarLen(BYTE* buf, int* time_out)
{
    int     time = 0;
    DWORD   ofs = 0;
    BYTE    t;

    do {
        t = buf[ofs++]; // MUS̃f^^C(ϒl)lbg[NoCgI[_[Ŏ߂Ă
        time = (time << 7) | (t & 127);
    } while (t & 128);
	
    *time_out = time;

    return ofs;
}

void WriteVarLen(BYTE** dest, int time)
{
    long    buffer;

    buffer = time & 0x7f;

    while ((time >>= 7) > 0)
        buffer = (buffer << 8) | 0x80 | (time & 0x7f);

    for (;;)
    {
        bputc((BYTE)(buffer & 0xff), dest);
        if (buffer & 0x80)
            buffer >>= 8;
        else
            break;
    }
}

extern int  snd_MusicVolume;

int MusToMidi(BYTE* musBuf, BYTE** midBuf, int* tics)
{
    mushead_t* musHead = (mushead_t *)musBuf;
    BYTE status, data1, data2;
    BYTE event = 0;
    DWORD scorePos = 0;
    int deltaTime = 0;
    int midiChan = 0;
    BYTE lastVel[16]; // MUSplay note(note on)̎note volume(velocity)OƓ͏ȗ邪AMIDInote on͕̎KvelocitŷőOnote volumeLĂ
    signed char chanMap[16];
    long trackLen;
	BYTE *tmpBuf, *buf_p;
	int filesize;

    if (!(musHead->ID[0] == 'M' && musHead->ID[1] == 'U' && musHead->ID[2] == 'S'))
        return 0;

	tmpBuf = alloca(1024*100);
	buf_p = tmpBuf;
    bwrite(midiHead, sizeof(midiHead), &buf_p);
#if 0
    {   // @2010/03/14
        bputc(0, &buf_p);
        bputc(0xF0, &buf_p);
        bputc(7, &buf_p);
        bputc(0x7F, &buf_p);
        bputc(0x7F, &buf_p);
        bputc(4, &buf_p);
        bputc(1, &buf_p);
        bputc(0, &buf_p);
        bputc((BYTE)(snd_MusicVolume*127/15), &buf_p);
        bputc(0xF7, &buf_p);
    }
#endif
    musBuf += musHead->scoreStart;

    memset(lastVel, 64, 16);
    memset(chanMap, -1, 15);
    chanMap[15] = 9; // percussionp̃`ĺAGeneralMIDI10Ԗڂ̃`lAMUS16Ԗڂ̃`l

	*tics = 0;

    while ((event & 0x70) != MUS_SCOREEND)
    {
        int muschan;
        BYTE musdat1 = 0;
        BOOL bTwoData = TRUE;

        event = musBuf[scorePos++];
        musdat1 = musBuf[scorePos++];
        muschan = event & 15; // 4rbgo

        if (chanMap[muschan] < 0)
        {
            // This is the first time this channel has been used,
            // so sets its volume to 127.
            bputc(0, &buf_p); // f^^C
            bputc((BYTE)(0xB0 | midiChan), &buf_p); // Xe[^XoCgB4rbg0xB̓Rg[`FW\B4rbg̓`l\B
            bputc(7, &buf_p); // data1 {[̃Zbg\Rg[io[(Mus_form.txtQ)
            bputc(127, &buf_p); // data2
            chanMap[muschan] = midiChan++; // (MUSł̃`lԂł)ꂽ0MIDĨ`lɕϊ
            if (midiChan == 9) // 9͉I񂷂
                midiChan++;
        }

        status = chanMap[muschan];

        switch (event & 0x70) // 0x702i01110000
        {
        case MUS_NOTEOFF:
            status |= MIDI_NOTEOFF;
            data1 = musdat1;
            data2 = 64; // ItxVeBBMIDIł܂gĂȂ(uWindowsTEhvO~OvP161)
            break;

        case MUS_NOTEON:
            status |= MIDI_NOTEON;
            data1 = musdat1 & 127;
            if (musdat1 & 128) // ŏʃrbgĂ
                lastVel[muschan] = musBuf[scorePos++]; // note volume(velocity)XV
            data2 = lastVel[muschan];
            //data2 = (BYTE)(snd_MusicVolume/15.0f * data2); // @2007/09/23
            break;

        case MUS_PITCHBEND:
            status |= MIDI_PITCHBEND; // MUSpitch wheel value8bitlMIDIł14bitl(uWindowsTEhvO~OvP154)Ȃ̂6bitVtg
            data1 = (musdat1 & 1) << 6; // ʃoCg
            data2 = musdat1 >> 1; // EVtgł͍̊Jrbg͍ŏ̃IyhunsignedɂȂƂ́A0 ߍ܂(MSDNCuurbgƂ̃VtgZqvQ)
            break;

        case MUS_SYSEVENT:
            status |= MIDI_CTRLCHANGE;
            data1 = CtrlNumShift[musdat1];
            data2 = musdat1 == 12 ? SwapSHORT(musHead->numChans) : 0; // Mono modeuA Programmer's GUID TO SOUNDvP310 Q
            break;

        case MUS_CTRLCHANGE:
            if (musdat1 == 0)
            {   // program(patch,instrument) change (BMIDĨf[^oCg1̏ꍇ)
                status |= MIDI_PRGMCHANGE;
                data1 = musBuf[scorePos++];
                bTwoData = FALSE;
            } else
            {
                status |= MIDI_CTRLCHANGE;
                data1 = CtrlNumShift[musdat1];
                data2 = musBuf[scorePos++];
            }
            break;

        case MUS_SCOREEND:
            status = 0xFF;	// B̃^Cxg(0xFFŎn܂)
            data1 = 0x2F;	// End of Track(uWindowsTEhvO~OvP236)
            data2 = 0x00;
            break;

        default:
            return 0;
        }

        WriteVarLen(&buf_p, deltaTime); // MIDȈꍇ͕Kf^^C

        bputc(status, &buf_p);
        bputc(data1, &buf_p);
        if (bTwoData)
            bputc(data2, &buf_p);

        if (event & 128) // Ԃ̃Cxg̒̍ŌȂ̂ŁAɃf^^C
            scorePos += ReadVarLen(&musBuf[scorePos], &deltaTime);
        else
            deltaTime = 0;

		*tics += deltaTime;
    }

    // fill in track length
	filesize = buf_p - tmpBuf;
    trackLen = filesize - 22;
	buf_p = tmpBuf + 18;
    bputc((BYTE)((trackLen >> 24) & 255), &buf_p);
    bputc((BYTE)((trackLen >> 16) & 255), &buf_p);
    bputc((BYTE)((trackLen >> 8) & 255), &buf_p);
    bputc((BYTE)(trackLen & 255), &buf_p);

	*midBuf = malloc(filesize);
	memcpy(*midBuf, tmpBuf, filesize);

    return filesize;
}

extern HWND		hMainWnd;
UINT			uDeviceId;
MCI_PLAY_PARMS  play;
DWORD           pausedtime;

void PlayMidi(char* midifile)
{
    MCI_OPEN_PARMS  open; // O[oϐɂopen֐ƃobeBO
    MCI_SET_PARMS   set;

	open.dwCallback       = (DWORD)hMainWnd;
	open.lpstrDeviceType  = "sequencer";
	open.lpstrElementName = midifile;
	mciSendCommand(0, MCI_OPEN, MCI_OPEN_TYPE | MCI_OPEN_ELEMENT, (DWORD)&open);
	uDeviceId = open.wDeviceID;

    set.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
    mciSendCommand(uDeviceId, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&set);

	play.dwCallback = (DWORD)hMainWnd;                          
	mciSendCommand(uDeviceId, MCI_PLAY, MCI_NOTIFY, (DWORD)&play);
}

void StopMidi(void)
{
    mciSendCommand(uDeviceId, MCI_STOP, 0, (DWORD)NULL);
    mciSendCommand(uDeviceId, MCI_CLOSE, 0, (DWORD)NULL);
}

void ReplayMidi(void)
{
    play.dwFrom = 0;                          
    mciSendCommand(uDeviceId, MCI_PLAY, MCI_NOTIFY | MCI_FROM, (DWORD)&play);
}

void PauseMidi(void)
{
    MCI_STATUS_PARMS    status;

    status.dwCallback = (DWORD)hMainWnd;
    status.dwItem     = MCI_STATUS_POSITION;
    mciSendCommand(uDeviceId, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&status);
    pausedtime = status.dwReturn;

    mciSendCommand(uDeviceId, MCI_STOP, 0, (DWORD)NULL); // MCISEQłMCI_STOP̓MCI_PAUSE͓̓(uAPIoCu3vp715Q)
}

void ResumeMidi(void)
{
    play.dwFrom = pausedtime;
    mciSendCommand(uDeviceId, MCI_PLAY, MCI_NOTIFY | MCI_FROM, (DWORD)&play);
}
