#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ
#include "m_bbox.h"
#include "i_system.h"
#include "r_main.h"
#include "doomstat.h"
#include "r_things.h"

//
// ClipWallSegment
// Clips the given range of columns
// and includes it in the new clip list.
//
typedef	struct
{
    angle_t/*int*/  first;
    angle_t/*int*/  last;
    
} cliprange_t;

#define MAXSEGS		32

// newend is one past the last valid seg
cliprange_t*	newend;
cliprange_t	solidsegs[MAXSEGS];

boolean CheckSolidSegs(angle_t angle1, angle_t angle2)
{
    cliprange_t*    start;

    start = solidsegs;
    while (start->last > angle1)
        start++;

    if (start->first >= angle1 && start->last <= angle2)
        return false;

    return true;
}

boolean AddSolidSeg(seg_t* seg)
{
    angle_t         angle1, angle2;
    cliprange_t     *start, *next;

    // @plutonia map12 ̃X^[gn_t߉OZN^[ł̕s
    if (seg->frontsector->ceilingpic == skyflatnum)
        return true;

    // @FOV̉ẼNbsOC̊px
    angle1 = R_PointToAngle(seg->v1->x, seg->v1->y) - viewangle + clipangle;
    if (angle1 == 0)
        return false;
    angle2 = R_PointToAngle(seg->v2->x, seg->v2->y) - viewangle + clipangle;
    if (angle1 == angle2)
        return false;
    if (angle1 > 2*clipangle && angle2 > 2*clipangle)
    {
        if (angle1 < ANG180 && angle2 > (angle1 + ANG180))
        {
            // @FOVEɉ؂Ă
            angle1 = 2*clipangle;
            angle2 = 0;
        }
        else
            return false; // @SFOV̊Otɉ؂Ă
    }
    if (angle1 < angle2)
    {
        if ((angle2 - angle1) > ANG180)
            angle2 = 0;
        else
            return false; // back face culling
    }
    else
    {
        if ((angle1 - angle2) > ANG180)
            return false; // back face culling
        if (angle1 > 2*clipangle)
            angle1 = 2*clipangle;
    }

    if (seg->backsector && 
        !(seg->backsector->ceilingheight <= seg->frontsector->floorheight || seg->backsector->floorheight >= seg->frontsector->ceilingheight))
        return CheckSolidSegs(angle1, angle2);

    // @ȉR_ClipSolidWallSegment()[r_bsp.c]Q

    start = solidsegs;
    while (start->last > angle1)
        start++;

    if (start->first >= angle1 && start->last <= angle2)
        return false;

    if (angle1 > start->first)
    {
        if (angle2 >= start->first) // @ŏ͕Kɓ
        {
            // Post is entirely visible (above start),
            //  so insert a new clippost.
            //R_StoreWallRange (first, last);
            
            // @̃`FbNKvȂ̂͐Vpost}鎞̂
            if (newend == &solidsegs[MAXSEGS-1])
                return true;

            next = newend;
            newend++;
            while (next != start)
            {
                *next = *(next-1);
                next--;
            }
            next->first = angle1;
            next->last = angle2;
            return true;
        }
        // There is a fragment above *start.
        //R_StoreWallRange (first, start->first - 1);
        // Now adjust the clip size.
        start->first = angle1;
    }

    // Bottom contained in start?
    if (angle2 >= start->last)
        return true;

    next = start;
    while (angle2 < (next+1)->first)
    {
        // There is a fragment between two posts.
        //R_StoreWallRange (next->last + 1, (next+1)->first - 1);
        next++;

        if (angle2 > next->last)
        {
            // Bottom is contained in next.
            // Adjust the clip size.
            start->last = next->last;
            goto crunch;
        }
    }

    // There is a fragment after *next.
    //R_StoreWallRange (next->last + 1, last);
    // Adjust the clip size.
    start->last = angle2;

    // Remove start+1 to next from the clip list,
    // because start now covers their area.
crunch:
    if (next == start)
    {
        // Post just extended past the bottom of one post.
        return true;
    }

    while (next++ != newend)
    {
        // Remove a post.
        *++start = *next;
    }

    newend = start+1;

    return true;
}

void R_ClearClipSegs(void)
{
    // @ɍŌ
    solidsegs[0].first = 0;
    solidsegs[0].last = 0;
    newend = solidsegs+1;
}

//
// R_CheckBBox
// Checks BSP node/subtree bounding box.
// Returns true
//  if some part of the bbox might be visible.
//
int	checkcoord[12][4] =
{
    {3,0,2,1},
    {3,0,2,0},
    {3,1,2,0},
    {0},
    {2,0,2,1},
    {0,0,0,0},
    {3,1,3,0},
    {0},
    {2,0,3,1},
    {2,1,3,1},
    {2,1,3,0}
};

boolean R_CheckBBox (fixed_t*	bspcoord) // @SimpleDoom03ł̃RgQ
{
    int			boxx;
    int			boxy;
    int			boxpos;

    fixed_t		x1;
    fixed_t		y1;
    fixed_t		x2;
    fixed_t		y2;
    
    angle_t		angle1;
    angle_t		angle2;
    angle_t		span;
    //angle_t		tspan;
/*    
    cliprange_t*	start;

    int			sx1;
    int			sx2;
*/    
    // Find the corners of the box
    // that define the edges from current viewpoint.
    if (viewx <= bspcoord[BOXLEFT])
	boxx = 0;
    else if (viewx < bspcoord[BOXRIGHT])
	boxx = 1;
    else
	boxx = 2;
		
    if (viewy >= bspcoord[BOXTOP])
	boxy = 0;
    else if (viewy > bspcoord[BOXBOTTOM])
	boxy = 1;
    else
	boxy = 2;
		
    boxpos = (boxy<<2)+boxx;
    if (boxpos == 5)
	return true;
	
    x1 = bspcoord[checkcoord[boxpos][0]];
    y1 = bspcoord[checkcoord[boxpos][1]];
    x2 = bspcoord[checkcoord[boxpos][2]];
    y2 = bspcoord[checkcoord[boxpos][3]];
    
    // check clip list for an open space
    angle1 = R_PointToAngle (x1, y1) - viewangle;
    angle2 = R_PointToAngle (x2, y2) - viewangle;
	
    span = angle1 - angle2;

    // Sitting on a line?
    if (span >= ANG180)
	return true;

#if 1
    // @angle_t^̑召̔ŕA܂ŖlƂčs邱Ƃɒ
    // @A-1*angle1̂悤ȉZ͋(A-angle1̂悤ɏƌxo)

    // @spanSFOV̊Oɂ邩?
    if (angle1 > span // @viewanglespan̊Oɂ
        && angle2 > clipangle 
        && -1*angle1/*@angle1̕p*/ > clipangle)
        return false;

    // @spanFOVŃNbv
    if (angle1-clipangle < span)
        angle1 = clipangle;
    if (clipangle < -1*angle2) // @angle1+clipangle < spanƂ(ӂangle1𑫂)
        angle2 = -1*clipangle;

    return CheckSolidSegs(angle1+clipangle, angle2+clipangle); // V1.93
#else
    tspan = angle1 + clipangle;
    if (tspan > 2*clipangle)
    {
	tspan -= 2*clipangle;

	// Totally off the left edge?
	if (tspan >= span)
	    return false;	

	angle1 = clipangle;
    }

    tspan = clipangle - angle2;
    if (tspan > 2*clipangle)
    {
	tspan -= 2*clipangle;

	// Totally off the left edge?
	if (tspan >= span)
	    return false;
	
	angle2 = -clipangle;
    }
#endif
/* @solidsegs[]gsolid wallsɉBĂbbox̔r
    // Find the first clippost
    //  that touches the source post
    //  (adjacent pixels are touching).
    angle1 = (angle1+ANG90)>>ANGLETOFINESHIFT;
    angle2 = (angle2+ANG90)>>ANGLETOFINESHIFT;
    sx1 = viewangletox[angle1];
    sx2 = viewangletox[angle2];

    // Does not cross a pixel.
    if (sx1 == sx2)
	return false;			
    sx2--;
	
    start = solidsegs;
    while (start->last < sx2)
	start++;
    
    if (sx1 >= start->first
	&& sx2 <= start->last)
    {
	// The clippost contains the new span.
	return false;
    }
*/
    return true;
}

#include "glext.h" // @http://www.opengl.org/registry/_E[h
extern PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB;
extern int      zlighton;
extern float    zlightrange;

void DrawQuad(float x1, float y1, float x2, float y2, float top, float bottom, float s1, float s2, float t1, float t2)
{
    if (zlighton)
    {
        glBegin(GL_QUADS);
		    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, s1, t1);
            glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x1-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y1-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
		    glVertex3f(x1, y1, top);
		    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, s1, t2);
            glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x1-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y1-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
		    glVertex3f(x1, y1, bottom);
		    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, s2, t2);
            glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x2-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y2-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
		    glVertex3f(x2, y2, bottom);
		    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, s2, t1);
            glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x2-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y2-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
		    glVertex3f(x2, y2, top);
        glEnd();
        return;
    }

    glBegin(GL_QUADS);
		glTexCoord2f(s1, t1);
		glVertex3f(x1, y1, top);
		glTexCoord2f(s1, t2);
		glVertex3f(x1, y1, bottom);
		glTexCoord2f(s2, t2);
		glVertex3f(x2, y2, bottom);
		glTexCoord2f(s2, t1);
		glVertex3f(x2, y2, top);
    glEnd();
}

extern GLuint*          texture_objects;
extern unsigned int*    gltextures;
//extern texture_t**      textures;

//
// R_Subsector
// Determine floor/ceiling planes.
// Add sprites of things in sector.
// Draw one or more line segments.
//
void R_Subsector (int num)
{
    subsector_t*    sub;
    sector_t*       sec;
    int             light;
    short           pic;
    int             i, j;
    float           x, y, z;
    seg_t*          seg;
    side_t*         sidedef;
    line_t*         linedef;
    float           x1, y1, x2, y2, top, bottom, s1, s2, t1, t2;
    fixed_t         wallheight, topcood;
    fixed_t         midtop, midbottom;

    sub = &subsectors[num];
    sec = sub->sector;

    if (fixedcolormap)
    {
        switch (fixedcolormap)
        {
        case 1:
            glColor4ub(255, 255, 255, 255);
            break;
        case INVERSECOLORMAP:
        default:
            glColor4ub(255, 255, 255, 255);
        }
    } else
    {
        light = sec->lightlevel + (extralight<<LIGHTSEGSHIFT);
        if (light > 255)
            light = 255;
        if (light < 0)
            light = 0;
        glColor4ub((byte)light, (byte)light, (byte)light, 255);
    }

    if (sec->ceilingheight > viewz)
    {
        pic = sec->ceilingpic;
        if (pic != skyflatnum)
        {
            i = firstflat + flattranslation[pic];
            if ((int)texture_objects[i] == -1)
            {
                static int lastnum = -1;
                if (i != lastnum)
                {
		            I_Debug("R_Subsector: ceiling flat texture not cached\n");
                    lastnum = i;
                }
                glBindTexture(GL_TEXTURE_2D, 0);
            } else
                glBindTexture(GL_TEXTURE_2D, texture_objects[i]);

            glBegin(GL_POLYGON);
            z = FIXEDTOFLOAT(sec->ceilingheight);
            for (j=0 ; j<sub->poly.numvertices ; j++)
            {
                x = sub->poly.vertices[j].x;
                y = sub->poly.vertices[j].y;
                if (zlighton)
                {
                    glMultiTexCoord2fARB(GL_TEXTURE0_ARB, x/64, y/64);
                    glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
                }
                else
                    glTexCoord2f(x/64, y/64);
		        glVertex3f(x, y, z);
            }
            glEnd();
        }
    }

    if (sec->floorheight < viewz)
    {
        pic = sec->floorpic;
        i = firstflat + flattranslation[pic];
        if ((int)texture_objects[i] == -1)
        {
		    static int lastnum = -1;
            if (i != lastnum)
            {
                I_Debug("R_Subsector: floor flat texture not cached\n");
                lastnum = i;
            }
            glBindTexture(GL_TEXTURE_2D, 0);
        } else
            glBindTexture(GL_TEXTURE_2D, texture_objects[i]);

        glBegin(GL_POLYGON);
        z = FIXEDTOFLOAT(sec->floorheight);    
        for (j=sub->poly.numvertices-1 ; j>=0 ; j--)
        {
            x = sub->poly.vertices[j].x;
            y = sub->poly.vertices[j].y;
            if (zlighton)
            {
                glMultiTexCoord2fARB(GL_TEXTURE0_ARB, x/64, y/64);
                glMultiTexCoord2fARB(GL_TEXTURE1_ARB, (x-FIXEDTOFLOAT(viewx))/zlightrange+0.5f, -(y-FIXEDTOFLOAT(viewy))/zlightrange+0.5f);
            }
            else
                glTexCoord2f(x/64, y/64);
		    glVertex3f(x, y, z);
        }
        glEnd();
    }

    seg = &segs[sub->firstline];
    for (i=0 ; i<sub->numlines ; i++, seg++)
    {
        if (!AddSolidSeg(seg)) // V1.93
            continue;

        sidedef = seg->sidedef;
        linedef = seg->linedef;

        if (!seg->backsector) // @R_StoreWallRange()[r_segs.c]Q
        {
            j = texturetranslation[sidedef->midtexture];
            if ((int)gltextures[j] == -1)
            {
                static int lastnum = -1;
                if (j != lastnum)
                {
                    I_Debug("R_Subsector: middle wall texture not cached. j = %d\n", j);
                    lastnum = j;
                }
                glBindTexture(GL_TEXTURE_2D, 0);
            } else
                glBindTexture(GL_TEXTURE_2D, gltextures[j]);
            x1 = FIXEDTOFLOAT(seg->v1->x);
            y1 = FIXEDTOFLOAT(seg->v1->y);
            x2 = FIXEDTOFLOAT(seg->v2->x);
            y2 = FIXEDTOFLOAT(seg->v2->y);
            top = FIXEDTOFLOAT(sec->ceilingheight);
            bottom = FIXEDTOFLOAT(sec->floorheight);
            s1 = FIXEDTOFLOAT(seg->offset + sidedef->textureoffset);
            s2 = s1 + seg->length;
            s1 /= (texturewidthmask[j]+1);
            s2 /= (texturewidthmask[j]+1);
            wallheight = sec->ceilingheight - sec->floorheight;
            if (linedef->flags & ML_DONTPEGBOTTOM)
                topcood = textureheight[j] - (wallheight % textureheight[j]);
            else
                topcood = 0;
            topcood += sidedef->rowoffset;
            t1 = FIXEDTOFLOAT(topcood);
            t2 = FIXEDTOFLOAT(topcood + wallheight);
            t1 /= (textureheight[j]>>FRACBITS);  // @>>FRACBITS̉Z͕̉\鐔ɂ͎gȂɒ
            t2 /= (textureheight[j]>>FRACBITS);
            DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, t1, t2);

            if (seg->frontsector->ceilingpic == skyflatnum)
            {
                glBindTexture(GL_TEXTURE_2D, 0);
                glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
                DrawQuad(x1, y1, x2, y2, 5000.0f, top, 0, 1.0f, 0, 1.0f); // @depth bufferɏ
                glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
            }
        } 
        else
        {
            if (seg->backsector->ceilingheight < seg->frontsector->ceilingheight)
            {
                if (seg->frontsector->ceilingpic != skyflatnum || seg->backsector->ceilingpic != skyflatnum)
                {                    
                    j = texturetranslation[sidedef->toptexture];
                    if ((int)gltextures[j] == -1)
                    {
                        static int lastnum = -1;
                        if (j != lastnum)
                        {
                            I_Debug("R_Subsector: top wall texture not cached\n");
                            lastnum = j;
                        }
                        glBindTexture(GL_TEXTURE_2D, 0);
                    } else
                        glBindTexture(GL_TEXTURE_2D, gltextures[j]);
                    x1 = FIXEDTOFLOAT(seg->v1->x);
                    y1 = FIXEDTOFLOAT(seg->v1->y);
                    x2 = FIXEDTOFLOAT(seg->v2->x);
                    y2 = FIXEDTOFLOAT(seg->v2->y);
                    top = FIXEDTOFLOAT(seg->frontsector->ceilingheight);
                    bottom = FIXEDTOFLOAT(seg->backsector->ceilingheight);
                    s1 = FIXEDTOFLOAT(seg->offset + sidedef->textureoffset);
                    s2 = s1 + seg->length;
                    s1 /= (texturewidthmask[j]+1);
                    s2 /= (texturewidthmask[j]+1);
                    wallheight = seg->frontsector->ceilingheight - seg->backsector->ceilingheight;
                    if (linedef->flags & ML_DONTPEGTOP)
                        topcood = 0;
                    else
                        topcood = textureheight[j] - (wallheight % textureheight[j]);
                    topcood += sidedef->rowoffset;
                    t1 = FIXEDTOFLOAT(topcood);
                    t2 = FIXEDTOFLOAT(topcood + wallheight);
                    t1 /= (textureheight[j]>>FRACBITS);
                    t2 /= (textureheight[j]>>FRACBITS);
                    DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, t1, t2);

                    if (seg->frontsector->ceilingpic == skyflatnum)
                    {
                        glBindTexture(GL_TEXTURE_2D, 0);
                        glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);
                        DrawQuad(x1, y1, x2, y2, 5000.0f, top, 0, 1.0f, 0, 1.0f); // @depth bufferɏ
                        glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
                    }
                }
            }

            if (seg->backsector->floorheight > seg->frontsector->floorheight)
            {
                j = texturetranslation[sidedef->bottomtexture];
                if ((int)gltextures[j] == -1)
                {
                    static int lastnum = -1;
                    if (j != lastnum)
                    {
                        I_Debug("R_Subsector: bottom wall texture not cached\n");
                        lastnum = j;
                    }
                    glBindTexture(GL_TEXTURE_2D, 0);
                } else
                    glBindTexture(GL_TEXTURE_2D, gltextures[j]);
                x1 = FIXEDTOFLOAT(seg->v1->x);
                y1 = FIXEDTOFLOAT(seg->v1->y);
                x2 = FIXEDTOFLOAT(seg->v2->x);
                y2 = FIXEDTOFLOAT(seg->v2->y);
                top = FIXEDTOFLOAT(seg->backsector->floorheight);
                bottom = FIXEDTOFLOAT(seg->frontsector->floorheight);
                s1 = FIXEDTOFLOAT(seg->offset + sidedef->textureoffset);
                s2 = s1 + seg->length;
                s1 /= (texturewidthmask[j]+1);
                s2 /= (texturewidthmask[j]+1);
                wallheight = seg->backsector->floorheight - seg->frontsector->floorheight;
                if (linedef->flags & ML_DONTPEGBOTTOM)
                    //topcood = textureheight[j] - (wallheight % textureheight[j]);
					// @lower textureunpeggedKp鎞́A(middle texture̎ƈ)
					// @{gAbvɂȂ킯ł͂ȂAɗׂ̕ǂmiddle textureƍ킹邽߂ɁA
					// @ʂĂZN^[̓V䂪eNX`W̎n_ɂȂ悤ɒ߂B
                    topcood = ((sec->ceilingheight - sec->floorheight) - wallheight) % textureheight[j];
                else
                    topcood = 0;
                topcood += sidedef->rowoffset;
                t1 = FIXEDTOFLOAT(topcood);
                t2 = FIXEDTOFLOAT(topcood + wallheight);
                t1 /= (textureheight[j]>>FRACBITS);
                t2 /= (textureheight[j]>>FRACBITS);
                DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, t1, t2);
            }

            if (sidedef->midtexture) // @masked texture͏㉺ɂ͌J肩Ȃɒ
            {
                if (seg->backsector->ceilingheight < seg->frontsector->ceilingheight)
                    midtop = seg->backsector->ceilingheight;
                else
                    midtop = seg->frontsector->ceilingheight;

                if (seg->backsector->floorheight > seg->frontsector->floorheight)
                    midbottom = seg->backsector->floorheight;
                else
                    midbottom = seg->frontsector->floorheight;

                j = texturetranslation[sidedef->midtexture];
                if ((int)gltextures[j] == -1)
                {
                    static int lastnum = -1;
                    if (j != lastnum)
                    {
                        I_Debug("R_Subsector: masked wall texture not cached. j = %d\n", j);
                        lastnum = j;
                    }
                    glBindTexture(GL_TEXTURE_2D, 0);
                } else
                    glBindTexture(GL_TEXTURE_2D, gltextures[j]);
                x1 = FIXEDTOFLOAT(seg->v1->x);
                y1 = FIXEDTOFLOAT(seg->v1->y);
                x2 = FIXEDTOFLOAT(seg->v2->x);
                y2 = FIXEDTOFLOAT(seg->v2->y);
                if (linedef->flags & ML_DONTPEGBOTTOM)
                {
                    bottom = FIXEDTOFLOAT(midbottom);
                    top = bottom + (textureheight[j]>>FRACBITS);
                } else
                {
                    top = FIXEDTOFLOAT(midtop);
                    bottom = top - (textureheight[j]>>FRACBITS);
                }
                s1 = FIXEDTOFLOAT(seg->offset + sidedef->textureoffset);
                s2 = s1 + seg->length;
                s1 /= (texturewidthmask[j]+1);
                s2 /= (texturewidthmask[j]+1);
                topcood = 0;
                topcood += sidedef->rowoffset;
                t1 = FIXEDTOFLOAT(topcood);
                t2 = FIXEDTOFLOAT(topcood + textureheight[j]);
                t1 /= (textureheight[j]>>FRACBITS);
                t2 /= (textureheight[j]>>FRACBITS);
                DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, t1, t2);
            }
        }
    }

    R_AddSprites(sec);
/*
    int			count;
    seg_t*		line;
    subsector_t*	sub;
	
#ifdef RANGECHECK
    if (num>=numsubsectors)
	I_Error ("R_Subsector: ss %i with numss = %i",
		 num,
		 numsubsectors);
#endif

    sscount++;
    sub = &subsectors[num];
    frontsector = sub->sector;
    count = sub->numlines;
    line = &segs[sub->firstline];

    if (frontsector->floorheight < viewz)
    {
	floorplane = R_FindPlane (frontsector->floorheight,
				  frontsector->floorpic,
				  frontsector->lightlevel);
    }
    else
	floorplane = NULL;
    
    if (frontsector->ceilingheight > viewz 
	|| frontsector->ceilingpic == skyflatnum)
    {
	ceilingplane = R_FindPlane (frontsector->ceilingheight,
				    frontsector->ceilingpic,
				    frontsector->lightlevel);
    }
    else
	ceilingplane = NULL;
		
    R_AddSprites (frontsector);	

    while (count--)
    {
	R_AddLine (line);
	line++;
    }*/
}

//
// RenderBSPNode
// Renders all subsectors below a given node,
//  traversing subtree recursively.
// Just call with BSP root.
void R_RenderBSPNode (int bspnum)
{
    node_t*	bsp;
    int		side;

    // Found a subsector?
    if (bspnum & NF_SUBSECTOR)
    {
        if (bspnum == -1)			
            R_Subsector (0);
        else
            R_Subsector (bspnum&(~NF_SUBSECTOR));
        return;
    }
		
    bsp = &nodes[bspnum];
    
    // Decide which side the view point is on.
    side = R_PointOnSide (viewx, viewy, bsp);

    // Recursively divide front space.
    R_RenderBSPNode (bsp->children[side]); 

    // Possibly divide back space.
    if (R_CheckBBox (bsp->bbox[side^1]))	
        R_RenderBSPNode (bsp->children[side^1]);
}
