#include <string.h>
#include <malloc.h>
#include "i_system.h"
#include "z_zone.h"
#include "w_wad.h"
#include "doomstat.h"
#include "p_local.h"
#include "r_sky.h"
#include "m_swap.h"
#include "r_data.h" //@texture_ť^`͂Ɉړ

int		firstflat;
int		lastflat;
int		numflats;

int		firstspritelump;
int		lastspritelump;
int		numspritelumps;

int		numtextures;
texture_t**	textures;

unsigned int*   gltextures;

// needed for texture pegging
fixed_t*		textureheight;  // @EV_DoFloor()[p_floor.c]łgĂ̂Œ

int*			texturewidthmask;

// for global animation
int*		flattranslation;
int*		texturetranslation;

// needed for pre rendering
fixed_t*	spritewidth;	
fixed_t*	spriteoffset;
fixed_t*	spritetopoffset;

fixed_t*    spriteheight;   // @tz

//
// R_InitTextures
// Initializes the texture list
//  with the textures from the world map.
//
void R_InitTextures (void)
{
	maptexture_t*	mtexture;
    texture_t*		texture;
    mappatch_t*		mpatch;
    texpatch_t*		patch;

	int			i;
    int			j;

	char		name[9];
    char*		names;
    char*		name_p;
    int			nummappatches;
    int*		patchlookup;

	int*		maptex;
    int*		maptex2;
    int*		maptex1;
	int			offset;
    int			maxoff;
    int			maxoff2;
    int			numtextures1;
    int			numtextures2;
	int*		directory;


	// Load the patch names from pnames.lmp.
    name[8] = 0;	
    names = W_CacheLumpName ("PNAMES", PU_STATIC);
    nummappatches = LONG ( *((int *)names) );
    name_p = names+4;
    patchlookup = alloca (nummappatches*sizeof(*patchlookup));
    
    for (i=0 ; i<nummappatches ; i++)
    {
		strncpy (name,name_p+i*8, 8);
		patchlookup[i] = W_CheckNumForName (name);
    }
    Z_Free (names);

	// Load the map texture definitions from textures.lmp.
    // The data is contained in one or two lumps,
    //  TEXTURE1 for shareware, plus TEXTURE2 for commercial.
    maptex = maptex1 = W_CacheLumpName ("TEXTURE1", PU_STATIC);
    numtextures1 = LONG(*maptex);
    maxoff = W_LumpLength (W_GetNumForName ("TEXTURE1"));
    directory = maptex+1;
	
    if (W_CheckNumForName ("TEXTURE2") != -1)
    {
		maptex2 = W_CacheLumpName ("TEXTURE2", PU_STATIC);
		numtextures2 = LONG(*maptex2);
		maxoff2 = W_LumpLength (W_GetNumForName ("TEXTURE2"));
    }
    else
    {
		maptex2 = NULL;
		numtextures2 = 0;
		maxoff2 = 0;
    }

    numtextures = numtextures1 + numtextures2;
	textures = Z_Malloc (numtextures*4, PU_STATIC, 0);
    textureheight = Z_Malloc (numtextures*4, PU_STATIC, 0);
    texturewidthmask = Z_Malloc (numtextures*4, PU_STATIC, 0);

    gltextures = malloc(numtextures*sizeof(*gltextures));
    memset(gltextures, 0xFF, numtextures*sizeof(*gltextures));

	for (i=0 ; i<numtextures ; i++, directory++)
    {
		if (i == numtextures1)
		{
			// Start looking in second texture file.
			maptex = maptex2;
			maxoff = maxoff2;
			directory = maptex+1;
		}
		
		offset = LONG(*directory);

		if (offset > maxoff)
			I_Error ("R_InitTextures: bad texture directory");
	
		mtexture = (maptexture_t *)((byte *)maptex + offset);

		texture = textures[i] =
			Z_Malloc (sizeof(texture_t)
				+ sizeof(texpatch_t)*(SHORT(mtexture->patchcount)-1),
					PU_STATIC, 0);
	
		texture->width = SHORT(mtexture->width);
		texture->height = SHORT(mtexture->height);
		texture->patchcount = SHORT(mtexture->patchcount);

		memcpy (texture->name, mtexture->name, sizeof(texture->name));
		mpatch = &mtexture->patches[0];
		patch = &texture->patches[0];

		for (j=0 ; j<texture->patchcount ; j++, mpatch++, patch++)
		{
			patch->originx = SHORT(mpatch->originx);
			patch->originy = SHORT(mpatch->originy);
			patch->patch = patchlookup[SHORT(mpatch->patch)];
			if (patch->patch == -1)
			{
				I_Error ("R_InitTextures: Missing patch in texture %s",
					texture->name);
			}
		}

        j = 1;
	    while (j*2 <= texture->width)
	        j<<=1;
        texturewidthmask[i] = j-1;

        textureheight[i] = texture->height<<FRACBITS;
    }

    Z_Free (maptex1);
    if (maptex2)
		Z_Free (maptex2);

	// Create translation table for global animation.
    texturetranslation = Z_Malloc ((numtextures+1)*4, PU_STATIC, 0);
    
    for (i=0 ; i<numtextures ; i++)
		texturetranslation[i] = i;
}

int*    useranimflat; // V2.1

//
// R_InitFlats
//
void R_InitFlats (void)
{
    int		i;
	
    firstflat = W_GetNumForName ("F_START") + 1;
    lastflat = W_GetNumForName ("F_END") - 1;
    numflats = lastflat - firstflat + 1;
	
    // Create translation table for global animation.
    flattranslation = Z_Malloc ((numflats+1)*4, PU_STATIC, 0);
    useranimflat = calloc(numflats+1, 4); // V2.1
    
    for (i=0 ; i<numflats ; i++) // @flattranslation̍XVP_UpdateSpecials()[p_spec.c]ōs
    {
        // V1.8
        int lump = W_CheckNumForName(lumpinfo[firstflat+i].name);
        if (lump > lastflat)
            flattranslation[i] = useranimflat[i]/*V2.1*/ = lump - firstflat;
        else
            flattranslation[i] = i;
    }
}

void CacheSpriteTextureObject(int lump);

//
// R_InitSpriteLumps
// Finds the width and hoffset of all sprites in the wad,
//  so the sprite does not need to be cached completely
//  just for having the header info ready during rendering.
//
void R_InitSpriteLumps (void)
{
    int		i;
    patch_t	*patch;
    int     lump;
    unsigned short* id;
	
    firstspritelump = W_GetNumForName ("S_START") + 1;
    lastspritelump = W_GetNumForName ("S_END") - 1;
    
    numspritelumps = lastspritelump - firstspritelump + 1;
    spritewidth = Z_Malloc (numspritelumps*4, PU_STATIC, 0);
    spriteoffset = Z_Malloc (numspritelumps*4, PU_STATIC, 0);
    spritetopoffset = Z_Malloc (numspritelumps*4, PU_STATIC, 0);
    spriteheight = Z_Malloc (numspritelumps*4, PU_STATIC, 0);
	
    for (i=0 ; i< numspritelumps ; i++)
    {
	if (!(i&63))
	    printf (".");

    // V1.5
    lump = W_GetNumForName(lumpinfo[firstspritelump+i].name);
    if (lump > lastspritelump)
    {
        patch = W_CacheLumpNum (lump, PU_CACHE);
        CacheSpriteTextureObject(lump);

        // V1.8
        id = W_CacheLumpNum(lump, PU_CACHE);
        if (  *id == 0x5089 ||  // PNG
              *id == 0xD8FF ||  // JPG
              *id == 0x4947 ||  // GIF
              *id == 0x4D42     // BMP
           )
            patch = W_CacheLumpNum (firstspritelump+i, PU_CACHE);
    }
    else
    {
	    patch = W_CacheLumpNum (firstspritelump+i, PU_CACHE);
        CacheSpriteTextureObject(firstspritelump+i);
    }
	spritewidth[i] = SHORT(patch->width)<<FRACBITS;
	spriteoffset[i] = SHORT(patch->leftoffset)<<FRACBITS;
	spritetopoffset[i] = SHORT(patch->topoffset)<<FRACBITS;
    spriteheight[i] = SHORT(patch->height)<<FRACBITS;
    }
}

//
// R_InitData
// Locates all the lumps
//  that will be used by all views
// Must be called after W_Init.
//
void R_InitData (void)
{
    R_InitTextures ();
    //printf ("\nInitTextures");
    R_InitFlats ();
    //printf ("\nInitFlats");
    R_InitSpriteLumps ();
    //printf ("\nInitSprites");
    //R_InitColormaps ();
    //printf ("\nInitColormaps");
}

int W_CheckNumForNameInIWAD (char* name);

//
// R_FlatNumForName
// Retrieval, get a flat number for a flat name.
//
int R_FlatNumForName (char* name)
{
    int		i;
    char	namet[9];

    //i = W_CheckNumForName (name);
    i = W_CheckNumForNameInIWAD(name); // V1.8

    // V1.93
    if (W_CheckNumForNameInIWAD("F_END") < lastflat) // @ICARUS.WADłF_END}[J[Ō̕ɒuF_START-F_ENDԂg債Ă
        i = W_CheckNumForName (name); 

    if (i == -1)
    {
	namet[8] = 0;
	memcpy (namet, name,8);
	I_Error ("R_FlatNumForName: %s not found",namet);
    }
    return i - firstflat;
}




//
// R_CheckTextureNumForName
// Check whether texture is available.
// Filter out NoTexture indicator.
//
int	R_CheckTextureNumForName (char *name)
{
    int		i;

    // "NoTexture" marker.
    if (name[0] == '-')		
	return 0;
		
    for (i=0 ; i<numtextures ; i++)
	//if (!strncmp/*strncasecmp*/ (textures[i]->name, name, 8) ) // case sensitive
	if (!_strnicmp/*strncasecmp*/ (textures[i]->name, name, 8) )
	    return i;
		
    return -1;
}



//
// R_TextureNumForName
// Calls R_CheckTextureNumForName,
//  aborts with error message.
//
int	R_TextureNumForName (char* name)
{
    int		i;
	
    i = R_CheckTextureNumForName (name);

    if (i==-1)
    {
	I_Error ("R_TextureNumForName: %s not found",
		 name);
    }
    return i;
}


void CacheFlatTextureObject(int lump);
void ReleaseTextureObject(int lump);
void CacheWallTextureObject(int texnum);
void ReleaseWallTextureObject(int texnum);
//void CacheSpriteTextureObject(int lump);

//
// Animating textures and planes
// There is another anim_t used in wi_stuff, unrelated.
//
typedef struct
{
    boolean	istexture;
    int		picnum;
    int		basepic;
    int		numpics;
    int		speed;
    
} anim_t;

extern anim_t   anims[];
extern anim_t*  lastanim;

extern int		switchlist[];
extern int		numswitches;
//
// R_PrecacheLevel
// Preloads all relevant graphics for the level.
//
int		flatmemory;
int		texturememory;
int		spritememory;

extern unsigned sky_textures[4][4];
extern unsigned skytexture0;
extern unsigned skytexture1;
extern unsigned skytexture2;
extern unsigned skytexture3;

void R_PrecacheLevel (void)
{
    char*		flatpresent;
    char*		texturepresent;
    //char*		spritepresent;

    int			i;
    int			j;
    //int			k;
    int			lump;
    
    texture_t*		texture;
    //thinker_t*		th;
    //spriteframe_t*	sf;

    anim_t*	anim;

    if (demoplayback)
	return;
    
    // Precache flats.
    flatpresent = alloca(numflats);
    memset (flatpresent,0,numflats);	

    for (i=0 ; i<numsectors ; i++)
    {
	flatpresent[sectors[i].floorpic] = 1;
	flatpresent[sectors[i].ceilingpic] = 1;
    }
	
    flatmemory = 0;

    for (i=0 ; i<numflats ; i++)
    {
        lump = firstflat + flattranslation[i]/*i*/; // V1.8
	    if (flatpresent[i])
	    {
	        flatmemory += lumpinfo[lump].size;
	        W_CacheLumpNum(lump, PU_CACHE);
            CacheFlatTextureObject(lump);
	    }/*
        else
            ReleaseTextureObject(lump);*/ // @ICARUS.WADł̓LbVĂXe[^Xo[p̉摜Ȃǂ̃eNX`IuWFNg[XĂ܂
    }                                     // @ICARUS.WADɂF_END}[J[F_START(StirlingŊmFς) 2012/03/06

    // Precache textures.
    texturepresent = alloca(numtextures);
    memset (texturepresent,0, numtextures);
	
    for (i=0 ; i<numsides ; i++)
    {
	texturepresent[sides[i].toptexture] = 1;
	texturepresent[sides[i].midtexture] = 1;
	texturepresent[sides[i].bottomtexture] = 1;
    }

    for (i=0 ; i<numtextures ; i++)
        if (texturepresent[i])
            for (j=0 ; j<numswitches*2 ; j++)
                if (switchlist[j] == i)
                    texturepresent[switchlist[j^1]] = 1;

    // Sky texture is always present.
    // Note that F_SKY1 is the name used to
    //  indicate a sky floor/ceiling as a flat,
    //  while the sky texture is stored like
    //  a wall texture, with an episode dependend
    //  name.
    texturepresent[skytexture] = 1;
	
    texturememory = 0;
    for (i=0 ; i<numtextures ; i++)
    {
	if (!texturepresent[i])
    {
        ReleaseWallTextureObject(i);
	    continue;
    }

	texture = textures[i];
	
	for (j=0 ; j<texture->patchcount ; j++)
	{
	    lump = texture->patches[j].patch;
	    texturememory += lumpinfo[lump].size;
	    W_CacheLumpNum(lump , PU_CACHE);
	}

    CacheWallTextureObject(i);
    }
    
    for (anim = anims ; anim < lastanim ; anim++)
        for (i=anim->basepic ; i<=anim->picnum ; i++)
            if (anim->istexture)
                CacheWallTextureObject(i);
            else
            {
                // V2.1
                if (useranimflat[i])
                    CacheFlatTextureObject(firstflat+useranimflat[i]);
                else
                    CacheFlatTextureObject(firstflat+i);
            }

    if (gamemode == commercial)
    {
        if (gamemap < 12)
            i = 0;
        else if (gamemap < 21)
            i = 2;
        else
            i = 3;
    }
    else
	    i = gameepisode - 1;

    if (sky_textures[i][0])
        skytexture0 = sky_textures[i][0];
    else
    {
        skytexture0 = skytexture1 = skytexture2 = skytexture3 = gltextures[skytexture];
        return;
    }

    if (sky_textures[i][1])
        skytexture1 = sky_textures[i][1];
    else
    {
        skytexture1 = skytexture2 = skytexture3 = sky_textures[i][0];
        return;
    }

    if (sky_textures[i][2])
        skytexture2 = sky_textures[i][2];
    else
    {
        skytexture2 = skytexture3 = sky_textures[i][1];
        return;
    }

    if (sky_textures[i][3])
        skytexture3 = sky_textures[i][3];
    else
    {
        skytexture3 = sky_textures[i][2];
        return;
    }
#if 0
    // Precache sprites.
    spritepresent = alloca(numsprites);
    memset (spritepresent,0, numsprites);
	
    for (th = thinkercap.next ; th != &thinkercap ; th=th->next)
    {
	if (th->function.acp1 == (actionf_p1)P_MobjThinker)
	    spritepresent[((mobj_t *)th)->sprite] = 1;
    }
/*	
    // @}bvTHINGƂĖIɕ\ȂIuWFNg(projectile, explosion, puff, etc)
    for (i=0 ; i<NUMMOBJTYPES ; i++)
        if (mobjinfo[i].doomednum == -1)
            spritepresent[states[mobjinfo[i].spawnstate].sprite] = 1;
*/
    spritememory = 0;
    for (i=0 ; i<numsprites ; i++)
    {
	if (!spritepresent[i])
	    continue;

	for (j=0 ; j<sprites[i].numframes ; j++)
	{
	    sf = &sprites[i].spriteframes[j];
	    for (k=0 ; k<8 ; k++)
	    {
	        lump = firstspritelump + sf->lump[k];
		    spritememory += lumpinfo[lump].size;
		    W_CacheLumpNum(lump , PU_CACHE);
            //if (lump > lastspritelump) // @PWADɊ܂܂JX^XvCg
                //CacheSpriteTextureObject(lump);
	    }
	}
    }
/* @R_InitSpriteLumps()Ɉړ
    for (i=firstspritelump ; i<=lastspritelump ; i++)
        CacheSpriteTextureObject(i);*/
#endif
}
