#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ       
#include <gl\glu.h>
#include <math.h>
#include "r_local.h"
#include "r_sky.h"
#include "i_system.h"

// increment every time a check is made
int             validcount = 1;

int/*lighttable_t**/    fixedcolormap;

// just for profiling purposes
int             framecount;

fixed_t			viewx;
fixed_t			viewy;
fixed_t			viewz;
angle_t			viewangle;
player_t*		viewplayer;

angle_t			clipangle;

fixed_t*		finecosine = &finesine[FINEANGLES/4];

// bumped light from gun blasts
int             extralight;


//
// R_PointToAngle
// To get a global angle from cartesian coordinates,
//  the coordinates are flipped until they are in
//  the first octant of the coordinate system, then
//  the y (<=x) is scaled and divided by x to get a
//  tangent (slope) value which is looked up in the
//  tantoangle[] table.
//
angle_t
R_PointToAngle
( fixed_t	x,
  fixed_t	y )
{	
    x -= viewx;
    y -= viewy;
    
    if ( (!x) && (!y) )
	return 0;

    if (x>= 0)
    {
	// x >=0
	if (y>= 0)
	{
	    // y>= 0

	    if (x>y)
	    {
		// octant 0
		return tantoangle[ SlopeDiv(y,x)];
	    }
	    else
	    {
		// octant 1
		return ANG90-1-tantoangle[ SlopeDiv(x,y)];
	    }
	}
	else
	{
	    // y<0
	    y = -y;

	    if (x>y)
	    {
		// octant 8
		return 0-tantoangle[SlopeDiv(y,x)];
	    }
	    else
	    {
		// octant 7
		return ANG270+tantoangle[ SlopeDiv(x,y)];
	    }
	}
    }
    else
    {
	// x<0
	x = -x;

	if (y>= 0)
	{
	    // y>= 0
	    if (x>y)
	    {
		// octant 3
		return ANG180-1-tantoangle[ SlopeDiv(y,x)];
	    }
	    else
	    {
		// octant 2
		return ANG90+ tantoangle[ SlopeDiv(x,y)];
	    }
	}
	else
	{
	    // y<0
	    y = -y;

	    if (x>y)
	    {
		// octant 4
		return ANG180+tantoangle[ SlopeDiv(y,x)];
	    }
	    else
	    {
		 // octant 5
		return ANG270-1-tantoangle[ SlopeDiv(x,y)];
	    }
	}
    }
    return 0;
}

angle_t
R_PointToAngle2
( fixed_t	x1,
  fixed_t	y1,
  fixed_t	x2,
  fixed_t	y2 )
{	
    viewx = x1;
    viewy = y1;
    
    return R_PointToAngle (x2, y2);
}

//
// R_PointOnSide
// Traverse BSP (sub) tree,
//  check point against partition plane.
// Returns side 0 (front) or 1 (back).
//
int
R_PointOnSide
( fixed_t	x,
  fixed_t	y,
  node_t*	node )
{
    fixed_t	dx;
    fixed_t	dy;
    fixed_t	left;
    fixed_t	right;
	
    if (!node->dx)
    {
	if (x <= node->x)
	    return node->dy > 0;
	
	return node->dy < 0;
    }
    if (!node->dy)
    {
	if (y <= node->y)
	    return node->dx < 0;
	
	return node->dx > 0;
    }
	
    dx = (x - node->x);
    dy = (y - node->y);
	
    // Try to quickly decide by looking at sign bits.
    if ( (node->dy ^ node->dx ^ dx ^ dy)&0x80000000 )
    {
	if  ( (node->dy ^ dx) & 0x80000000 )
	{
	    // (left is negative)
	    return 1;
	}
	return 0;
    }

    left = FixedMul ( node->dy>>FRACBITS , dx );
    right = FixedMul ( dy , node->dx>>FRACBITS );
	
    if (right < left)
    {
	// front side
	return 0;
    }
    // back side
    return 1;			
}

//
// R_PointInSubsector
//
subsector_t*
R_PointInSubsector
( fixed_t	x,
  fixed_t	y )
{
    node_t*	node;
    int		side;
    int		nodenum;

    // single subsector is a special case
    if (!numnodes)				
	return subsectors;
		
    nodenum = numnodes-1;

    while (! (nodenum & NF_SUBSECTOR) )
    {
	node = &nodes[nodenum];
	side = R_PointOnSide (x, y, node);
	nodenum = node->children[side];
    }
	
    return &subsectors[nodenum & ~NF_SUBSECTOR];
}

//
// R_SetViewSize
// Do not really change anything here,
//  because it might be in the middle of a refresh.
// The change will take effect next refresh.
//
boolean		setsizeneeded;
int		setblocks;
int		setdetail;


void
R_SetViewSize
( int		blocks,
  int		detail )
{
    setsizeneeded = true;
    setblocks = blocks;
    setdetail = detail;
}

extern int screenwidth;
extern int screenheight;
extern int viewportwidth;
float   skyspan;
double  ortholeft, orthoright;
int     fovy;
int     orgaspect;

void R_ExecuteSetViewSize (void)
{
    //GLdouble    fovy;
    GLdouble    aspect;
    int         propwidth;
    double      margin;
    double      factor;

    setsizeneeded = false;

    //fovy = 70;
    if (orgaspect)
        factor = 200.0/240.0;
    else
        factor = 1.0;
    aspect = (double)viewportwidth / ((double)screenheight*factor);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective((double)fovy, aspect, 1, 65536*1.4142);

    clipangle = (angle_t)(atan(tan(fovy/2*3.1416/180)*aspect)*MAXINT/3.1416);
    skyspan = (float)(clipangle*2) / ANG90; // @90x1.0Ƃ̎p̒l

    propwidth = screenheight*4/3;
    if (viewportwidth > propwidth)
    {
        margin = ((double)viewportwidth/propwidth*320-320)/2;
        ortholeft = -margin;
        orthoright = 320 + margin;
    } else
    {
        ortholeft = 0;
        orthoright = 320;
    }
}

//
// R_Init
//
extern int	detailLevel;
extern int	screenblocks;

void R_Init (void)
{
    R_InitData ();/*
	printf ("\nR_InitData");
    R_InitPointToAngle ();
    printf ("\nR_InitPointToAngle");
    R_InitTables ();
    // viewwidth / viewheight / detailLevel are set by the defaults
    printf ("\nR_InitTables");*/

    R_SetViewSize (screenblocks, detailLevel);/*
    R_InitPlanes ();
    printf ("\nR_InitPlanes");
    R_InitLightTables ();
    printf ("\nR_InitLightTables");*/
    R_InitSkyMap ();
    //printf ("\nR_InitSkyMap");
    R_InitTranslationTables ();
    //printf ("\nR_InitTranslationsTables");
	
    framecount = 0;
}

extern unsigned int*    gltextures;
//extern int              numstthings;
extern int              numvisthings;
extern int  interframe;

GLuint skytexture0, skytexture1, skytexture2, skytexture3;

//
// R_SetupFrame
//
void R_SetupFrame (player_t* player)
{		
    //int		i;
    float       deltaangle;
    //float       s1, s2;
    static fixed_t  oldx, oldy, oldz;
    static angle_t  oldangle;
    GLuint tex1=0, tex2=0, tex3=0;
    float s1l, s1r, s2l, s2r, s3l, s3r;
    float x1, x2;
    
    viewplayer = player;
    if (interframe && framecount)
    {
        // @Visual C++ ł͕t̒lEVtgꍇ͎ZpVtg
        viewx = oldx + ((player->mo->x - oldx)>>1);
        viewy = oldy + ((player->mo->y - oldy)>>1);
        viewz = oldz + ((player->viewz - oldz)>>1);
        viewangle = oldangle + (angle_t)(((signed)(player->mo->angle - oldangle))>>1);
    }
    else
    {
        viewx = oldx = player->mo->x;
        viewy = oldy = player->mo->y;
        viewz = oldz = player->viewz;
        viewangle = oldangle = player->mo->angle;
    }
    extralight = player->extralight;

    // @Ԑɋ̃eNX``悷

    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, 256, 200, 0);

#if 0
    s1 = 1.0f - ((viewangle%ANG90)/(float)ANG90);
    s2 = s1 + skyspan;

    glBindTexture(GL_TEXTURE_2D, gltextures[skytexture]);
    glBegin(GL_QUADS);
		glTexCoord2f(s1, 0);
		glVertex3f(0, 0, -0.9999f);
		glTexCoord2f(s1, 1.0);
		glVertex3f(0, 128, -0.9999f);
		glTexCoord2f(s2, 1.0);
		glVertex3f(256, 128, -0.9999f);
		glTexCoord2f(s2, 0);
		glVertex3f(256, 0, -0.9999f);
    glEnd();
#else
    if ((viewangle+clipangle) < ANG90)
    {
        tex1 = skytexture0;
        s1l = 1.0f - (((viewangle+clipangle)%ANG90)/(float)ANG90);
        if ((viewangle-clipangle) < ANG90)
        {
            s1r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            x1 = 256.0f;
        }
        else
        {
            tex2 = skytexture3;
            s1r = 1.0f;
            x1 = (1.0f-s1l)/skyspan*256.0f;
            s2l = 0;
            if ((viewangle-clipangle) > ANG270)
            {
                s2r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
                x2 = 256.0f;
            }
            else
            {
                tex3 = skytexture2;
                s2r = 1.0f;
                x2 = x1 + 1.0f/skyspan*256.0f;
                s3l = 0;
                s3r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            }
        }
    }
    else if ((viewangle+clipangle) < ANG180)
    {
        tex1 = skytexture1;
        s1l = 1.0f - (((viewangle+clipangle)%ANG90)/(float)ANG90);
        if ((viewangle-clipangle) < ANG180 && (viewangle-clipangle) > ANG90)
        {
            s1r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            x1 = 256.0f;
        }
        else
        {
            tex2 = skytexture0;
            s1r = 1.0f;
            x1 = (1.0f-s1l)/skyspan*256.0f;
            s2l = 0;
            if ((viewangle-clipangle) < ANG90)
            {
                s2r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
                x2 = 256.0f;
            }
            else
            {
                tex3 = skytexture3;
                s2r = 1.0f;
                x2 = x1 + 1.0f/skyspan*256.0f;
                s3l = 0;
                s3r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            }
        }
    }
    else if ((viewangle+clipangle) < ANG270)
    {
        tex1 = skytexture2;
        s1l = 1.0f - (((viewangle+clipangle)%ANG90)/(float)ANG90);
        if ((viewangle-clipangle) > ANG180)
        {
            s1r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            x1 = 256.0f;
        }
        else
        {
            tex2 = skytexture1;
            s1r = 1.0f;
            x1 = (1.0f-s1l)/skyspan*256.0f;
            s2l = 0;
            if ((viewangle-clipangle) > ANG90)
            {
                s2r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
                x2 = 256.0f;
            }
            else
            {
                tex3 = skytexture0;
                s2r = 1.0f;
                x2 = x1 + 1.0f/skyspan*256.0f;
                s3l = 0;
                s3r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            }
        }
    }
    else
    {
        tex1 = skytexture3;
        s1l = 1.0f - (((viewangle+clipangle)%ANG90)/(float)ANG90);
        if ((viewangle-clipangle) > ANG270)
        {
            s1r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            x1 = 256.0f;
        }
        else
        {
            tex2 = skytexture2;
            s1r = 1.0f;
            x1 = (1.0f-s1l)/skyspan*256.0f;
            s2l = 0;
            if ((viewangle-clipangle) > ANG180)
            {
                s2r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
                x2 = 256.0f;
            }
            else
            {
                tex3 = skytexture1;
                s2r = 1.0f;
                x2 = x1 + 1.0f/skyspan*256.0f;
                s3l = 0;
                s3r = 1.0f - (((viewangle-clipangle)%ANG90)/(float)ANG90);
            }
        }
    }

    glBindTexture(GL_TEXTURE_2D, tex1);
    glBegin(GL_QUADS);
		glTexCoord2f(s1l, 0);
		glVertex3f(0, 0, -0.9999f);
		glTexCoord2f(s1l, 1.0);
		glVertex3f(0, 128, -0.9999f);
		glTexCoord2f(s1r, 1.0);
		glVertex3f(x1, 128, -0.9999f);
		glTexCoord2f(s1r, 0);
		glVertex3f(x1, 0, -0.9999f);
    glEnd();

    if (tex2)
    {
        glBindTexture(GL_TEXTURE_2D, tex2);
        glBegin(GL_QUADS);
		    glTexCoord2f(s2l, 0);
		    glVertex3f(x1, 0, -0.9999f);
		    glTexCoord2f(s2l, 1.0);
		    glVertex3f(x1, 128, -0.9999f);
		    glTexCoord2f(s2r, 1.0);
		    glVertex3f(x2, 128, -0.9999f);
		    glTexCoord2f(s2r, 0);
		    glVertex3f(x2, 0, -0.9999f);
        glEnd();
    }

    if (tex3)
    {
        glBindTexture(GL_TEXTURE_2D, tex3);
        glBegin(GL_QUADS);
		    glTexCoord2f(s3l, 0);
		    glVertex3f(x2, 0, -0.9999f);
		    glTexCoord2f(s3l, 1.0);
		    glVertex3f(x2, 128, -0.9999f);
		    glTexCoord2f(s3r, 1.0);
		    glVertex3f(256, 128, -0.9999f);
		    glTexCoord2f(s3r, 0);
		    glVertex3f(256, 0, -0.9999f);
        glEnd();
    }
#endif
    glPopMatrix();
/*
    viewsin = finesine[viewangle>>ANGLETOFINESHIFT];
    viewcos = finecosine[viewangle>>ANGLETOFINESHIFT];
	
    sscount = 0;

    if (player->fixedcolormap)
    {
	fixedcolormap =
	    colormaps
	    + player->fixedcolormap*256*sizeof(lighttable_t);
	
	walllights = scalelightfixed;

	for (i=0 ; i<MAXLIGHTSCALE ; i++)
	    scalelightfixed[i] = fixedcolormap;
    }
    else
	fixedcolormap = 0;
*/
    fixedcolormap = player->fixedcolormap; // @p_user.cŌ㕔Q

    framecount++;
    validcount++;

    //numstthings = 0;
    numvisthings = 0;

    deltaangle = (signed)(viewangle - ANG90)*180.0f/MAXINT;
    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
    glRotatef(-deltaangle, 0.0f, 0.0f, 1.0f);
	glTranslatef(-FIXEDTOFLOAT(viewx), -FIXEDTOFLOAT(viewy), -FIXEDTOFLOAT(viewz));
}

void R_DrawPlayerSprites (void);
//void DrawSemitransThings(void);
void DrawVisThings(void);

#include "glext.h" // @http://www.opengl.org/registry/_E[h
extern PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
extern int      zlighton;
extern GLuint   zlightmap;

//
// R_RenderView
//
void R_RenderPlayerView (player_t* player)
{    
    R_SetupFrame (player);

    // Clear buffers.
    R_ClearClipSegs ();/*
    R_ClearDrawSegs ();
    R_ClearPlanes ();
    R_ClearSprites ();
    
    // check for new console commands.
    NetUpdate ();
*/
    if (zlighton)
    {
        glActiveTextureARB(GL_TEXTURE1_ARB);
        glBindTexture(GL_TEXTURE_2D, zlightmap);
        glActiveTextureARB(GL_TEXTURE0_ARB);
    }

    glAlphaFunc(GL_GREATER, 0.9f);
    // The head node is the last node output.
    R_RenderBSPNode (numnodes-1);

    glAlphaFunc(GL_NOTEQUAL, 0);
    //DrawSemitransThings();
    DrawVisThings();

    if (zlighton)
    {
        glActiveTextureARB(GL_TEXTURE1_ARB);
        glBindTexture(GL_TEXTURE_2D, 0);
        glActiveTextureARB(GL_TEXTURE0_ARB);
    }

    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(ortholeft, orthoright, 200, 0);

    R_DrawPlayerSprites ();

    glPopMatrix();
/*    
    // Check for new console commands.
    NetUpdate ();
    
    R_DrawPlanes ();
    
    // Check for new console commands.
    NetUpdate ();
    
    R_DrawMasked ();

    // Check for new console commands.
    NetUpdate ();*/	
}
