#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ
#include <stdlib.h>
#include "r_local.h"
#include "i_system.h"
#include "z_zone.h"
#include "w_wad.h"
#include "doomstat.h"

// variables used to look up
//  and range check thing_t sprites patches
spritedef_t*	sprites;
int				numsprites;

spriteframe_t	sprtemp[29];
int				maxframe;
char*			spritename;

//
// R_InstallSpriteLump
// Local function for R_InitSprites.
//
void
R_InstallSpriteLump
( int		lump,
  unsigned	frame,
  unsigned	rotation,
  boolean	flipped )
{
    int		r;
	
    if (frame >= 29 || rotation > 8)
	I_Error("R_InstallSpriteLump: "
		"Bad frame characters in lump %i", lump);
	
    if ((int)frame > maxframe)
	maxframe = frame;
		
    if (rotation == 0)
    {
	// the lump should be used for all rotations
	if (sprtemp[frame].rotate == false)
	    I_Error ("R_InitSprites: Sprite %s frame %c has "
		     "multip rot=0 lump", spritename, 'A'+frame);

	if (sprtemp[frame].rotate == true)
	    I_Error ("R_InitSprites: Sprite %s frame %c has rotations "
		     "and a rot=0 lump", spritename, 'A'+frame);
			
	sprtemp[frame].rotate = false;
	for (r=0 ; r<8 ; r++)
	{
	    sprtemp[frame].lump[r] = lump - firstspritelump;
	    sprtemp[frame].flip[r] = (byte)flipped;
	}
	return;
    }
	
    // the lump is only used for one rotation
    if (sprtemp[frame].rotate == false)
	I_Error ("R_InitSprites: Sprite %s frame %c has rotations "
		 "and a rot=0 lump", spritename, 'A'+frame);
		
    sprtemp[frame].rotate = true;

    // make 0 based
    rotation--;		
    if (sprtemp[frame].lump[rotation] != -1)
	I_Error ("R_InitSprites: Sprite %s : %c : %c "
		 "has two lumps mapped to it",
		 spritename, 'A'+frame, '1'+rotation);
		
    sprtemp[frame].lump[rotation] = lump - firstspritelump;
    sprtemp[frame].flip[rotation] = (byte)flipped;
}

//
// R_InitSpriteDefs
// Pass a null terminated list of sprite names
//  (4 chars exactly) to be used.
// Builds the sprite rotation matrixes to account
//  for horizontally flipped sprites.
// Will report an error if the lumps are inconsistant. 
// Only called at startup.
//
// Sprite lump names are 4 characters for the actor,
//  a letter for the frame, and a number for the rotation.
// A sprite that is flippable will have an additional
//  letter/number appended.
// The rotation character can be 0 to signify no rotations.
//
void R_InitSpriteDefs (char** namelist) 
{ 
    char**	check;
    int		i;
    int		l;
    int		intname;
    int		frame;
    int		rotation;
    int		start;
    int		end;
    int		patched;
		
    // count the number of sprite names
    check = namelist;
    while (*check != NULL)
	check++;

    numsprites = check-namelist; // @VS2013ł138ɂ͂ȂȂ
	
    if (!numsprites)
	return;
		
    sprites = Z_Malloc(numsprites *sizeof(*sprites), PU_STATIC, NULL);
	
    start = firstspritelump-1;
    end = lastspritelump+1;
	
    // scan all the lump names for each of the names,
    //  noting the highest frame letter.
    // Just compare 4 characters as ints
    for (i=0 ; i<numsprites ; i++)
    {
	spritename = namelist[i];
	memset (sprtemp,-1, sizeof(sprtemp));
		
	maxframe = -1;
	intname = *(int *)namelist[i];
	
	// scan the lumps,
	//  filling in the frames for whatever is found
	for (l=start+1 ; l<end ; l++)
	{
	    if (*(int *)lumpinfo[l].name == intname)
	    {
		frame = lumpinfo[l].name[4] - 'A';
		rotation = lumpinfo[l].name[5] - '0';

		if (modifiedgame)
        {
		    patched = W_GetNumForName (lumpinfo[l].name);
            if (patched > lastspritelump)
                lumpinfo[patched].handle = l - firstspritelump;
        }
		else
		    patched = l;

		R_InstallSpriteLump (patched, frame, rotation, false);

		if (lumpinfo[l].name[6]) // @xR_InstallSpriteLump()ʂ
		{
		    frame = lumpinfo[l].name[6] - 'A';
		    rotation = lumpinfo[l].name[7] - '0';
		    R_InstallSpriteLump (patched/*l*/, frame, rotation, true);
		}
	    }
	}
		
	if (maxframe == -1)
	{
	    sprites[i].numframes = 0;
	    continue;
	}
		
	maxframe++;

	// check the frames that were found for completeness
	for (frame = 0 ; frame < maxframe ; frame++)
	{
	    switch ((int)sprtemp[frame].rotate)
	    {
	      case -1:
		// no rotations were found for that frame at all
		I_Error ("R_InitSprites: No patches found "
			 "for %s frame %c", namelist[i], frame+'A');
		break;
		
	      case 0:
		// only the first rotation is needed
		break;
			
	      case 1:
		// must have all 8 frames
		for (rotation=0 ; rotation<8 ; rotation++)
		    if (sprtemp[frame].lump[rotation] == -1)
			I_Error ("R_InitSprites: Sprite %s frame %c "
				 "is missing rotations",
				 namelist[i], frame+'A');
		break;
	    }
	}
	
	// allocate space for the frames present and copy sprtemp to it
	sprites[i].numframes = maxframe;
	sprites[i].spriteframes = 
	    Z_Malloc (maxframe * sizeof(spriteframe_t), PU_STATIC, NULL);
	memcpy (sprites[i].spriteframes, sprtemp, maxframe*sizeof(spriteframe_t));
    }

}

//
// R_InitSprites
// Called at program start.
//
void R_InitSprites (char** namelist) // @P_Init()Ă΂
{/*
	int		i;
	
    for (i=0 ; i<SCREENWIDTH ; i++)
    {
	negonearray[i] = -1;
    }*/
	
    R_InitSpriteDefs (namelist);
}

int distcmp(const void *elem1, const void *elem2)
{
    mobj_t* th1 = *((mobj_t **)elem1);
    mobj_t* th2 = *((mobj_t **)elem2);
    float   dx, dy, val1, val2;

    dx = FIXEDTOFLOAT(th1->x - viewx);
    dy = FIXEDTOFLOAT(th1->y - viewy);
    val1 = dx*dx + dy*dy;

    dx = FIXEDTOFLOAT(th2->x - viewx);
    dy = FIXEDTOFLOAT(th2->y - viewy);
    val2 = dx*dx + dy*dy;

    if (val1 > val2)
        return -1;
    else if (val1 < val2)
        return 1;
    return 0;
}

extern GLuint*  texture_objects;
void DrawQuad(float x1, float y1, float x2, float y2, float top, float bottom, float s1, float s2, float t1, float t2);

// V1.6
mobj_t* visthings[MAXVISSPRITES];
int     numvisthings;

extern int shadow;
extern GLuint* shadow_textures;

void DrawVisThings(void)
{
    int             i, j;
    mobj_t*         thing;
    int             light;
    spritedef_t*	sprdef;
    spriteframe_t*  sprframe;
    angle_t         ang;
    int             lump;
    unsigned        rot;
    boolean         flip;
    fixed_t         dx, dy;
    float           x1, y1, x2, y2, top, bottom, s1, s2;

    qsort(visthings, numvisthings, sizeof(mobj_t*), distcmp);

    for (i=0 ; i<numvisthings ; i++)
    {
        thing = visthings[i];

        // decide which patch to use for sprite relative to player
        sprdef = &sprites[thing->sprite];
        sprframe = &sprdef->spriteframes[thing->frame&FF_FRAMEMASK];

        ang = R_PointToAngle (thing->x, thing->y);
        if (sprframe->rotate)
        {
	        // choose a different rotation based on player view
	        //ang = R_PointToAngle (thing->x, thing->y);
	        rot = (ang-thing->angle+(unsigned)(ANG45/2)*9)>>29;
	        lump = sprframe->lump[rot];
	        flip = (boolean)sprframe->flip[rot];
        }
        else
        {
	        // use single rotation for all views
	        lump = sprframe->lump[0];
	        flip = (boolean)sprframe->flip[0];
        }

        j = lump + firstspritelump;
        if ((int)texture_objects[j] == -1)
        {
            static int first = 1;
            if (first)
            {
                char    name[9];
                name[8] = 0;
                strncpy(name, lumpinfo[j].name, 8);
		        I_Debug("DrawSemitransThings: sprite texture not cached. %s\n", name);
                first = 0;
            }
            continue;
        } 
        //else
            //glBindTexture(GL_TEXTURE_2D, texture_objects[j]);

        if (j > lastspritelump)
            lump = lumpinfo[j].handle;

        //ang += ANG90;
        ang = viewangle + ANG90;
        dx = FixedMul(spriteoffset[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spriteoffset[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x1 = FIXEDTOFLOAT(thing->x + dx);
        y1 = FIXEDTOFLOAT(thing->y + dy);
        ang += ANG180;
        if (1) // V1.93
        {
            angle_t angle1, angle2;
            fixed_t x = thing->x + dx;
            fixed_t y = thing->y + dy;
            
            angle1 = R_PointToAngle(x, y) - viewangle + clipangle;
            dx = FixedMul(spritewidth[lump], finecosine[ang>>ANGLETOFINESHIFT]);
            dy = FixedMul(spritewidth[lump], finesine[ang>>ANGLETOFINESHIFT]);
            x += dx;
            y += dy;
            angle2 = R_PointToAngle(x, y) - viewangle + clipangle;
            // @solidsegsɂAʏBSPc[łȂΏoȂ̂ŁApOthing̔r̂
            if (angle1 > 2*clipangle && angle2 > 2*clipangle)
            {
                if (angle1 < (ANG90 + clipangle))
                    ; // @FOVEɉ؂Ă
                else
                    continue;
            }
        }
        dx = FixedMul(spritewidth[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spritewidth[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x2 = x1 + FIXEDTOFLOAT(dx);
        y2 = y1 + FIXEDTOFLOAT(dy);
        if ((thing->z + spritetopoffset[lump] - spriteheight[lump]) < thing->subsector->sector->floorheight)
            bottom = FIXEDTOFLOAT(thing->subsector->sector->floorheight);
        else
            bottom = FIXEDTOFLOAT(thing->z + spritetopoffset[lump] - spriteheight[lump]);
        top = bottom + FIXEDTOFLOAT(spriteheight[lump]);
        
        if (flip)
        {
            s1 = 1.0f;
            s2 = 0;
        }
        else
        {
            s1 = 0;
            s2 = 1.0f;
        }

        if (shadow && !(thing->flags&MF_SHADOW) && shadow_textures[j])
        {
            float x1off = x1 + FIXEDTOFLOAT(spriteheight[lump])/2.0f * FIXEDTOFLOAT(finecosine[viewangle>>ANGLETOFINESHIFT]);
            float y1off = y1 + FIXEDTOFLOAT(spriteheight[lump])/2.0f * FIXEDTOFLOAT(finesine[viewangle>>ANGLETOFINESHIFT]);
            float x2off = x1off + (x2 - x1);
            float y2off = y1off + (y2 - y1);
            float z = FIXEDTOFLOAT(thing->subsector->sector->floorheight) + 0.2f/*0.02f*/; // @Zobt@16rbg̕gȂ0.02ł͖

            glColor4ub(255, 255, 255, 100);
            glBindTexture(GL_TEXTURE_2D, shadow_textures[j]);
            glBegin(GL_QUADS);
		        glTexCoord2f(s1, 0);
		        glVertex3f(x1off, y1off, z);
		        glTexCoord2f(s1, 1.0f);
		        glVertex3f(x1, y1, z);
		        glTexCoord2f(s2, 1.0f);
		        glVertex3f(x2, y2, z);
		        glTexCoord2f(s2, 0);
		        glVertex3f(x2off, y2off, z);
            glEnd();
        }

        light = thing->subsector->sector->lightlevel + (extralight<<LIGHTSEGSHIFT);
        if (light > 255)
            light = 255;
        if (light < 0)
            light = 0;
        if (fixedcolormap)
        {
            switch (fixedcolormap)
            {
            case 1:
                glColor4ub(255, 255, 255, 255);
                break;
            case INVERSECOLORMAP:
            default:
                glColor4ub(255, 255, 255, 255);
            }
        }
        else if (thing->frame & FF_FULLBRIGHT)
            glColor4ub(255, 255, 255, 255);
        else if (thing->flags & MF_SHADOW)
            glColor4ub((byte)light, (byte)light, (byte)light, 64);
        else
            glColor4ub((byte)light, (byte)light, (byte)light, 255);

        glBindTexture(GL_TEXTURE_2D, texture_objects[j]);

        DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, 0, 1.0f);
    }
}

mobj_t* semitransthings[64];
int     numstthings;

void DrawSemitransThings(void)
{
    int             i, j;
    mobj_t*         thing;
    spritedef_t*	sprdef;
    spriteframe_t*  sprframe;
    angle_t         ang;
    int             lump;
    unsigned        rot;
    boolean         flip;
    fixed_t         dx, dy;
    float           x1, y1, x2, y2, top, bottom, s1, s2;

    qsort(semitransthings, numstthings, sizeof(mobj_t*), distcmp);

    glColor4ub(255, 255, 255, 64);
    for (i=0 ; i<numstthings ; i++)
    {
        thing = semitransthings[i];

        // decide which patch to use for sprite relative to player
        sprdef = &sprites[thing->sprite];
        sprframe = &sprdef->spriteframes[thing->frame&FF_FRAMEMASK];

        ang = R_PointToAngle (thing->x, thing->y);
        if (sprframe->rotate)
        {
	        // choose a different rotation based on player view
	        //ang = R_PointToAngle (thing->x, thing->y);
	        rot = (ang-thing->angle+(unsigned)(ANG45/2)*9)>>29;
	        lump = sprframe->lump[rot];
	        flip = (boolean)sprframe->flip[rot];
        }
        else
        {
	        // use single rotation for all views
	        lump = sprframe->lump[0];
	        flip = (boolean)sprframe->flip[0];
        }

        j = lump + firstspritelump;
        if ((int)texture_objects[j] == -1)
        {
            static int first = 1;
            if (first)
            {
                char    name[9];
                name[8] = 0;
                strncpy(name, lumpinfo[j].name, 8);
		        I_Debug("DrawSemitransThings: sprite texture not cached. %s\n", name);
                first = 0;
            }
            continue;
        } 
        else
            glBindTexture(GL_TEXTURE_2D, texture_objects[j]);

        if (j > lastspritelump)
            lump = lumpinfo[j].handle;

        //ang += ANG90;
        ang = viewangle + ANG90;
        dx = FixedMul(spriteoffset[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spriteoffset[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x1 = FIXEDTOFLOAT(thing->x + dx);
        y1 = FIXEDTOFLOAT(thing->y + dy);
        ang += ANG180;
        dx = FixedMul(spritewidth[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spritewidth[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x2 = x1 + FIXEDTOFLOAT(dx);
        y2 = y1 + FIXEDTOFLOAT(dy);
        if ((thing->z + spritetopoffset[lump] - spriteheight[lump]) < thing->subsector->sector->floorheight)
            bottom = FIXEDTOFLOAT(thing->subsector->sector->floorheight);
        else
            bottom = FIXEDTOFLOAT(thing->z + spritetopoffset[lump] - spriteheight[lump]);
        top = bottom + FIXEDTOFLOAT(spriteheight[lump]);
        
        if (flip)
        {
            s1 = 1.0f;
            s2 = 0;
        }
        else
        {
            s1 = 0;
            s2 = 1.0f;
        }

        DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, 0, 1.0f);
    }
}

//
// R_AddSprites
// During BSP traversal, this adds sprites by sector.
//
void R_AddSprites (sector_t* sec)
{
    mobj_t*		    thing;
    spritedef_t*	sprdef;
    spriteframe_t*  sprframe;
    angle_t         ang;
    int             lump;
    unsigned        rot;
    boolean         flip;
    int             i;
    int             light;
    fixed_t         dx, dy;
    float           x1, y1, x2, y2, top, bottom, s1, s2;

    // BSP is traversed by subsector.
    // A sector might have been split into several
    //  subsectors during BSP building.
    // Thus we check whether its already added.
    if (sec->validcount == validcount)
	    return;		

    // Well, now it will be done.
    sec->validcount = validcount;

    if (!sec->thinglist)
        return;

    for (thing = sec->thinglist ; thing ; thing = thing->snext)
    {
        // V1.6
        if (numvisthings < MAXVISSPRITES)
        {
            if (thing == viewplayer->mo) // @28/10/2010ǉ
                continue;

            visthings[numvisthings++] = thing;
            continue;
        }
        else
            break;

        // decide which patch to use for sprite relative to player
        sprdef = &sprites[thing->sprite];
        sprframe = &sprdef->spriteframes[thing->frame&FF_FRAMEMASK];

        ang = R_PointToAngle (thing->x, thing->y);
        if (sprframe->rotate)
        {
	        // choose a different rotation based on player view
	        //ang = R_PointToAngle (thing->x, thing->y);
	        rot = (ang-thing->angle+(unsigned)(ANG45/2)*9)>>29;
	        lump = sprframe->lump[rot];
	        flip = (boolean)sprframe->flip[rot];
        }
        else
        {
	        // use single rotation for all views
	        lump = sprframe->lump[0];
	        flip = (boolean)sprframe->flip[0];
        }

        i = lump + firstspritelump;
        if ((int)texture_objects[i] == -1)
        {
            static int first = 1;
            if (first)
            {
                char    name[9];
                name[8] = 0;
                strncpy(name, lumpinfo[i].name, 8);
		        I_Debug("R_AddSprites: sprite texture not cached. %s\n", name);
                first = 0;
            }
            continue;
        } 
        else
            glBindTexture(GL_TEXTURE_2D, texture_objects[i]);

        if (thing->flags & MF_SHADOW)
        {
            if (numstthings < 64)
                semitransthings[numstthings++] = thing;
            continue;
        }
        else if (fixedcolormap)
        {
            switch (fixedcolormap)
            {
            case 1:
                glColor4ub(255, 255, 255, 255);
                break;
            case INVERSECOLORMAP:
            default:
                glColor4ub(255, 255, 255, 255);
            }
        }
        else if (thing->frame & FF_FULLBRIGHT)
        {
            glColor4ub(255, 255, 255, 255);
        }
        else
        {
            light = sec->lightlevel + (extralight<<LIGHTSEGSHIFT);
            if (light > 255)
                light = 255;
            if (light < 0)
                light = 0;
            glColor4ub((byte)light, (byte)light, (byte)light, 255);
        }

        if (i > lastspritelump)
            lump = lumpinfo[i].handle;

        //ang += ANG90;
        ang = viewangle + ANG90;
        dx = FixedMul(spriteoffset[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spriteoffset[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x1 = FIXEDTOFLOAT(thing->x + dx);
        y1 = FIXEDTOFLOAT(thing->y + dy);
        ang += ANG180;
        dx = FixedMul(spritewidth[lump], finecosine[ang>>ANGLETOFINESHIFT]);
        dy = FixedMul(spritewidth[lump], finesine[ang>>ANGLETOFINESHIFT]);
        x2 = x1 + FIXEDTOFLOAT(dx);
        y2 = y1 + FIXEDTOFLOAT(dy);
        if ((thing->z + spritetopoffset[lump] - spriteheight[lump]) < sec->floorheight)
            bottom = FIXEDTOFLOAT(sec->floorheight);
        else
            bottom = FIXEDTOFLOAT(thing->z + spritetopoffset[lump] - spriteheight[lump]);
        top = bottom + FIXEDTOFLOAT(spriteheight[lump]);
        
        if (flip)
        {
            s1 = 1.0f;
            s2 = 0;
        }
        else
        {
            s1 = 0;
            s2 = 1.0f;
        }

        DrawQuad(x1, y1, x2, y2, top, bottom, s1, s2, 0, 1.0f);
    }
}

extern int setblocks;
extern int specmode;

//
// R_DrawPSprite
//
void R_DrawPSprite (pspdef_t* psp)
{
    spritedef_t*	sprdef;
    spriteframe_t*  sprframe;
    int			    lump;
    boolean		    flip;
    int             i;
    int             light;
    float           x1, y1, x2, y2;
    int             s1, s2;

    sprdef = &sprites[psp->state->sprite];
    sprframe = &sprdef->spriteframes[ psp->state->frame & FF_FRAMEMASK ];

    lump = sprframe->lump[0];
    flip = (boolean)sprframe->flip[0];

    i = lump + firstspritelump;
    if ((int)texture_objects[i] == -1)
    {
        static int first = 1;
        if (first)
        {
            char    name[9];
            name[8] = 0;
            strncpy(name, lumpinfo[i].name, 8);
		    I_Debug("R_DrawPSprite: sprite texture not cached. %s\n", name);
            first = 0;
        }
        return;
    } 
    else
        glBindTexture(GL_TEXTURE_2D, texture_objects[i]);

    if (viewplayer->powers[pw_invisibility] > 4*32
	|| viewplayer->powers[pw_invisibility] & 8)
    {
	    // shadow draw
	    glColor4ub(255, 255, 255, 64);
    }
    else if (fixedcolormap)
    {
	    // fixed color
	    switch (fixedcolormap)
        {
        case 1:
            glColor4ub(255, 255, 255, 255);
            break;
        case INVERSECOLORMAP:
        default:
            glColor4ub(255, 255, 255, 255);
        }
    }
    else if (psp->state->frame & FF_FULLBRIGHT)
    {
	    // full bright
	    glColor4ub(255, 255, 255, 255);
    }
    else
    {
	    // local light
        light = viewplayer->mo->subsector->sector->lightlevel + (extralight<<LIGHTSEGSHIFT);
        if (light > 255)
            light = 255;
        if (light < 0)
            light = 0;
        glColor4ub((byte)light, (byte)light, (byte)light, 255);
    }

    if (i > lastspritelump)
        lump = lumpinfo[i].handle;

    x1 = FIXEDTOFLOAT(psp->sx - spriteoffset[lump]);
    x2 = x1 + FIXEDTOFLOAT(spritewidth[lump]);
    y1 = FIXEDTOFLOAT(psp->sy - spritetopoffset[lump]);
    if (setblocks <= 10 && !specmode)
        y1 -= 32.0f;
    y2 = y1 + FIXEDTOFLOAT(spriteheight[lump]);

    if (flip)
    {
        s1 = 1;
        s2 = 0;
    }
    else
    {
        s1 = 0;
        s2 = 1;
    }

    glBegin(GL_QUADS);
		glTexCoord2i(s1, 0);
		glVertex2f(x1, y1);
		glTexCoord2i(s1, 1);
		glVertex2f(x1, y2);
		glTexCoord2i(s2, 1);
		glVertex2f(x2, y2);
		glTexCoord2i(s2, 0);
		glVertex2f(x2, y1);
	glEnd();
}

//
// R_DrawPlayerSprites
//
void R_DrawPlayerSprites (void)
{
    int         i;
    pspdef_t*   psp;

    // add all active psprites @eo鉊Ȃǂ́A{̂Ƃ͕ʂ̃XvCgɂȂĂ
    glDepthMask(GL_FALSE);
    for (i=0, psp=viewplayer->psprites;
	 i<NUMPSPRITES/*2*/;
	 i++,psp++)
    {
	if (psp->state)
	    R_DrawPSprite (psp);
    }
    glDepthMask(GL_TRUE);
}
