#include <math.h>
#include <stdlib.h>
#include "i_system.h"
#include "i_sound.h"
#include "sounds.h"
#include "s_sound.h"
#include "r_main.h"
#include "w_wad.h"
#include "z_zone.h"
#include "m_argv.h"

#define S_CLIPPING_DIST		(1200*0x10000)
#define S_CLOSE_DIST		(160*0x10000)
#define S_ATTENUATOR		((S_CLIPPING_DIST-S_CLOSE_DIST)>>FRACBITS)
#define S_STEREO_SWING		(96*0x10000)

#define NORM_SEP		128

int 		snd_SfxVolume /*= 15*/;
int 		snd_MusicVolume /*= 15*/;

static boolean      mus_paused;
static musicinfo_t* mus_playing=0;

int			numChannels;

int     nomusic;

void S_Init
( int		sfxVolume,
  int		musicVolume )
{/*
    int     p;

    p = M_CheckParm("-nomusic");
    if (p && p < myargc-1)
        nomusic = atoi(myargv[p+1]);*/
    nomusic = M_CheckParm("-nomusic");

    S_SetMusicVolume(musicVolume);

    I_SetChannels();
}

void S_StopSound(void *origin)
{
    I_StopSound(origin);
}

int
S_AdjustSoundParams
( mobj_t*	listener,
  mobj_t*	source,
  int*		vol,
  int*		sep,
  int*		pitch )
{
    fixed_t	approx_dist;
    fixed_t	adx;
    fixed_t	ady;
    angle_t	angle;

    // calculate the distance to sound origin
    //  and clip it if necessary
    adx = abs(listener->x - source->x);
    ady = abs(listener->y - source->y);

    // From _GG1_ p.428. Appox. eucledian distance fast.
    approx_dist = adx + ady - ((adx < ady ? adx : ady)>>1);
    
    if (gamemap != 8
	&& approx_dist > S_CLIPPING_DIST)
    {
	return 0;
    }
    
    // angle of source to listener
    angle = R_PointToAngle2(listener->x,
			    listener->y,
			    source->x,
			    source->y);

    if (angle > listener->angle)
	angle = angle - listener->angle;
    else
	angle = angle + (0xffffffff - listener->angle);

    angle >>= ANGLETOFINESHIFT;

    // stereo separation
    *sep = 128 - (FixedMul(S_STEREO_SWING,finesine[angle])>>FRACBITS);

    // volume calculation
    if (approx_dist < S_CLOSE_DIST)
    {
	*vol = snd_SfxVolume;
    }
    else if (gamemap == 8)
    {
	if (approx_dist > S_CLIPPING_DIST)
	    approx_dist = S_CLIPPING_DIST;

	*vol = 15+ ((snd_SfxVolume-15)
		    *((S_CLIPPING_DIST - approx_dist)>>FRACBITS))
	    / S_ATTENUATOR;
    }
    else
    {
	// distance effect
	*vol = (snd_SfxVolume
		* ((S_CLIPPING_DIST - approx_dist)>>FRACBITS))
	    / S_ATTENUATOR; 
    }
    
    return (*vol > 0);
}

void
S_StartSound
( void*		origin_p,
  int		sfx_id )
{
    int         rc;
    int         sep;
    int         pitch;
    int         priority;
    int			volume = snd_SfxVolume;
    mobj_t*		origin = (mobj_t *)origin_p;

    // check for bogus sound #
    if (sfx_id < 1 || sfx_id > NUMSFX)
        I_Error("Bad sfx #: %d", sfx_id);

    if (origin && origin != players[consoleplayer].mo)
    {
        rc = S_AdjustSoundParams(players[consoleplayer].mo, origin, &volume, &sep, &pitch);
        if (origin->x == players[consoleplayer].mo->x && origin->y == players[consoleplayer].mo->y)
			sep = NORM_SEP;
        if (!rc)
			return;
    } else
		sep = NORM_SEP;

    // kill old sound
    S_StopSound(origin);

    I_StartSound(sfx_id, volume, sep, pitch, priority, origin);
}

//
// Per level startup code.
// Kills playing sounds at start of level,
//  determines music if any, changes music.
//
void S_Start(void)
{
    int mnum;

    I_StopAllSound();

    // start new music for the level
    mus_paused = 0;
  
    if (gamemode == commercial)
        mnum = mus_runnin + gamemap - 1;
    else
    {
        int spmus[]=
        {
            // Song - Who? - Where?
      
            mus_e3m4,	// American	e4m1
            mus_e3m2,	// Romero	e4m2
            mus_e3m3,	// Shawn	e4m3
            mus_e1m5,	// American	e4m4
            mus_e2m7,	// Tim 	e4m5
            mus_e2m4,	// Romero	e4m6
            mus_e2m6,	// J.Anderson	e4m7 CHIRON.WAD
            mus_e2m5,	// Shawn	e4m8
            mus_e1m9	// Tim		e4m9
        };
    
        if (gameepisode < 4)
            mnum = mus_e1m1 + (gameepisode-1)*9 + gamemap-1;
        else
            mnum = spmus[gamemap-1];
    }	
  
    // HACK FOR COMMERCIAL
    //  if (commercial && mnum > mus_e3m9)	
    //      mnum -= mus_e3m9;
  
    S_ChangeMusic(mnum, true);
}

void S_StopMusic(void)
{
    if (mus_playing)
    {
	    I_StopSong();
	    mus_playing = 0;
    }
}

void S_PauseSound(void)
{
    if (mus_playing && !mus_paused)
    {
        I_PauseSong();
        mus_paused = true;
    }
}

void S_ResumeSound(void)
{
    if (mus_playing && mus_paused)
    {
        I_ResumeSong();
        mus_paused = false;
    }
}

void S_SetMusicVolume(int volume)
{
    I_SetMusicVolume(volume);
}

void S_SetSfxVolume(int volume)
{
}

void
S_ChangeMusic
( int			musicnum,
  int			looping )
{
    musicinfo_t*    music;
    char		    namebuf[9];

	if (nomusic)
		return;

    if ((musicnum <= mus_None) || (musicnum >= NUMMUSIC))
	    I_Error("Bad music number %d", musicnum);
    else
	    music = &S_music[musicnum];

    if (mus_playing == music)
	    return;

    // shutdown old music
    S_StopMusic();

    // get lumpnum if neccessary
    if (!music->lumpnum)
    {
        sprintf(namebuf, "d_%s", music->name);
        music->lumpnum = W_GetNumForName(namebuf);
    }

    music->data = (void *)W_CacheLumpNum(music->lumpnum, PU_MUSIC);

    I_PlaySong(music, looping);

    mus_playing = music;
}

//
// Starts some music with the music id found in sounds.h.
//
void S_StartMusic(int m_id)
{
    S_ChangeMusic(m_id, false);
}
