#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ
#include "d_event.h"
#include "doomstat.h"
#include "v_video.h"
#include "z_zone.h"
#include "w_wad.h"
#include "st_stuff.h"
#include "st_lib.h"
#include "m_random.h"
#include "r_local.h"
#include "m_cheat.h"
#include "dstrings.h"
#include "s_sound.h"
#include "g_game.h"
#include "p_inter.h"
#include "sounds.h"
#include "f_finale.h"
#include "i_system.h"


// Location of status bar
#define ST_X				0
#define ST_X2				104

#define ST_FX  			143
#define ST_FY  			169

// Number of status faces.
#define ST_NUMPAINFACES		5
#define ST_NUMSTRAIGHTFACES	3
#define ST_NUMTURNFACES		2   // right, left
#define ST_NUMSPECIALFACES	3   // ouch, evil, pissed

#define ST_FACESTRIDE \
          (ST_NUMSTRAIGHTFACES+ST_NUMTURNFACES+ST_NUMSPECIALFACES)

#define ST_NUMEXTRAFACES    2   // god, dead

#define ST_NUMFACES \
          (ST_FACESTRIDE*ST_NUMPAINFACES+ST_NUMEXTRAFACES)

#define ST_TURNOFFSET		(ST_NUMSTRAIGHTFACES)
#define ST_OUCHOFFSET		(ST_TURNOFFSET + ST_NUMTURNFACES)
#define ST_EVILGRINOFFSET	(ST_OUCHOFFSET + 1)
#define ST_RAMPAGEOFFSET	(ST_EVILGRINOFFSET + 1)
#define ST_GODFACE			(ST_NUMPAINFACES*ST_FACESTRIDE)
#define ST_DEADFACE			(ST_GODFACE+1)

#define ST_FACESX			143
#define ST_FACESY			168

#define ST_EVILGRINCOUNT		(2*TICRATE)
#define ST_STRAIGHTFACECOUNT	(TICRATE/2)
#define ST_TURNCOUNT		(1*TICRATE)
#define ST_OUCHCOUNT		(1*TICRATE)
#define ST_RAMPAGEDELAY		(2*TICRATE)

#define ST_MUCHPAIN			20

// Location and size of statistics,
//  justified according to widget type.
// Problem is, within which space? STbar? Screen?
// Note: this could be read in by a lump.
//       Problem is, is the stuff rendered
//       into a buffer,
//       or into the frame buffer?

// AMMO number pos.
#define ST_AMMOWIDTH		3	
#define ST_AMMOX			44
#define ST_AMMOY			171

// HEALTH number pos.
#define ST_HEALTHWIDTH		3	
#define ST_HEALTHX			90
#define ST_HEALTHY			171

// Weapon pos.
#define ST_ARMSX			111
#define ST_ARMSY			172
#define ST_ARMSBGX			104
#define ST_ARMSBGY			168
#define ST_ARMSXSPACE		12
#define ST_ARMSYSPACE		10

// Frags pos.
#define ST_FRAGSX			138
#define ST_FRAGSY			171	
#define ST_FRAGSWIDTH		2

// ARMOR number pos.
#define ST_ARMORWIDTH		3
#define ST_ARMORX			221
#define ST_ARMORY			171

// Key icon positions.
#define ST_KEY0WIDTH		8
#define ST_KEY0HEIGHT		5
#define ST_KEY0X			239
#define ST_KEY0Y			171
#define ST_KEY1WIDTH		ST_KEY0WIDTH
#define ST_KEY1X			239
#define ST_KEY1Y			181
#define ST_KEY2WIDTH		ST_KEY0WIDTH
#define ST_KEY2X			239
#define ST_KEY2Y			191

// Ammunition counter.
#define ST_AMMO0WIDTH		3
#define ST_AMMO0HEIGHT		6
#define ST_AMMO0X			288
#define ST_AMMO0Y			173
#define ST_AMMO1WIDTH		ST_AMMO0WIDTH
#define ST_AMMO1X			288
#define ST_AMMO1Y			179
#define ST_AMMO2WIDTH		ST_AMMO0WIDTH
#define ST_AMMO2X			288
#define ST_AMMO2Y			191
#define ST_AMMO3WIDTH		ST_AMMO0WIDTH
#define ST_AMMO3X			288
#define ST_AMMO3Y			185

// Indicate maximum ammunition.
// Only needed because backpack exists.
#define ST_MAXAMMO0WIDTH		3
#define ST_MAXAMMO0HEIGHT		5
#define ST_MAXAMMO0X		314
#define ST_MAXAMMO0Y		173
#define ST_MAXAMMO1WIDTH		ST_MAXAMMO0WIDTH
#define ST_MAXAMMO1X		314
#define ST_MAXAMMO1Y		179
#define ST_MAXAMMO2WIDTH		ST_MAXAMMO0WIDTH
#define ST_MAXAMMO2X		314
#define ST_MAXAMMO2Y		191
#define ST_MAXAMMO3WIDTH		ST_MAXAMMO0WIDTH
#define ST_MAXAMMO3X		314
#define ST_MAXAMMO3Y		185

// Dimensions given in characters.
#define ST_MSGWIDTH			52


// main player in game
static player_t*	plyr;


// whether left-side main status bar is active
static boolean		st_statusbaron;

// !deathmatch
static boolean		st_notdeathmatch; 

// !deathmatch
static boolean		st_fragson;

// !deathmatch && st_statusbaron
static boolean		st_armson;


// main bar left
static patch_t*		sbar;

// 0-9, tall numbers
static patch_t*		tallnum[10];

// tall % sign
static patch_t*		tallpercent;

// 0-9, short, yellow (,different!) numbers
static patch_t*		shortnum[10];

// 3 key-cards, 3 skulls
static patch_t*		keys[NUMCARDS]; 

// face status patches
static patch_t*		faces[ST_NUMFACES];

// face background
static patch_t*		faceback;

 // main bar right
static patch_t*		armsbg;

// weapon ownership patches
static patch_t*		arms[6][2];


// ready-weapon widget
static st_number_t	w_ready;

 // in deathmatch only, summary of frags stats
static st_number_t	w_frags;

// health widget
static st_percent_t	w_health;

// arms background
static st_binicon_t	w_armsbg; 

// weapon ownership widgets
static st_multicon_t	w_arms[6];

// face status widget
static st_multicon_t	w_faces; 

// keycard widgets
static st_multicon_t	w_keyboxes[3];

// armor widget
static st_percent_t	w_armor;

// ammo widgets
static st_number_t	w_ammo[4];

// max ammo widgets
static st_number_t	w_maxammo[4];


// number of frags so far in deathmatch
static int	st_fragscount;

// used to use appopriately pained face
static int	st_oldhealth = -1;

// used for evil grin
static boolean	oldweaponsowned[NUMWEAPONS];

// count until face changes
static int	st_facecount = 0;

// current face index, used by w_faces
static int	st_faceindex = 0;

// holds key-type for each key box on bar
static int	keyboxes[3];

// a random number per tick
static int	st_randomnumber;


// Massive bunches of cheat shit
//  to keep it from being easy to figure them out.
// Yeah, right...
unsigned char	cheat_mus_seq[] =
{
    0xb2, 0x26, 0xb6, 0xae, 0xea, 1, 0, 0, 0xff
};

unsigned char	cheat_choppers_seq[] =
{
    0xb2, 0x26, 0xe2, 0x32, 0xf6, 0x2a, 0x2a, 0xa6, 0x6a, 0xea, 0xff // id...
};

unsigned char	cheat_god_seq[] =
{
    0xb2, 0x26, 0x26, 0xaa, 0x26, 0xff  // iddqd
};

unsigned char	cheat_ammo_seq[] =
{
    0xb2, 0x26, 0xf2, 0x66, 0xa2, 0xff	// idkfa
};

unsigned char	cheat_ammonokey_seq[] =
{
    0xb2, 0x26, 0x66, 0xa2, 0xff	// idfa
};

// Smashing Pumpkins Into Samml Piles Of Putried Debris. 
unsigned char	cheat_noclip_seq[] =
{
    0xb2, 0x26, 0xea, 0x2a, 0xb2,	// idspispopd
    0xea, 0x2a, 0xf6, 0x2a, 0x26, 0xff
};

//
unsigned char	cheat_commercial_noclip_seq[] =
{
    0xb2, 0x26, 0xe2, 0x36, 0xb2, 0x2a, 0xff	// idclip
}; 

unsigned char	cheat_powerup_seq[7][10] =
{
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0x6e, 0xff }, 	// beholdv
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0xea, 0xff }, 	// beholds
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0xb2, 0xff }, 	// beholdi
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0x6a, 0xff }, 	// beholdr
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0xa2, 0xff }, 	// beholda
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0x36, 0xff }, 	// beholdl
    { 0xb2, 0x26, 0x62, 0xa6, 0x32, 0xf6, 0x36, 0x26, 0xff }		// behold
};

unsigned char	cheat_clev_seq[] =
{
    0xb2, 0x26,  0xe2, 0x36, 0xa6, 0x6e, 1, 0, 0, 0xff	// idclev
};

// my position cheat
unsigned char	cheat_mypos_seq[] =
{
    0xb2, 0x26, 0xb6, 0xba, 0x2a, 0xf6, 0xea, 0xff	// idmypos
}; 

// @finaleĂяo`[g
unsigned char	cheat_fin_seq[] =
{
    0xb2, 0x26, 0x66, 0xb2, 0x76, 0xff	// idfin
};
cheatseq_t	cheat_fin = { cheat_fin_seq, 0 };

// Now what?
cheatseq_t	cheat_mus = { cheat_mus_seq, 0 };
cheatseq_t	cheat_god = { cheat_god_seq, 0 };
cheatseq_t	cheat_ammo = { cheat_ammo_seq, 0 };
cheatseq_t	cheat_ammonokey = { cheat_ammonokey_seq, 0 };
cheatseq_t	cheat_noclip = { cheat_noclip_seq, 0 };
cheatseq_t	cheat_commercial_noclip = { cheat_commercial_noclip_seq, 0 };

cheatseq_t	cheat_powerup[7] =
{
    { cheat_powerup_seq[0], 0 },
    { cheat_powerup_seq[1], 0 },
    { cheat_powerup_seq[2], 0 },
    { cheat_powerup_seq[3], 0 },
    { cheat_powerup_seq[4], 0 },
    { cheat_powerup_seq[5], 0 },
    { cheat_powerup_seq[6], 0 }
};

cheatseq_t	cheat_choppers = { cheat_choppers_seq, 0 };
cheatseq_t	cheat_clev = { cheat_clev_seq, 0 };
cheatseq_t	cheat_mypos = { cheat_mypos_seq, 0 };



// Respond to keyboard input events,
//  intercept cheats.
boolean
ST_Responder (event_t* ev)
{
    int		i;

    // if a user keypress...
  /*else*/ if (ev->type == ev_keydown)
  {
        char  c;
        
        c = tolower(ev->data1);

    if (!netgame)
    {
      // b. - enabled for more debug fun.
      // if (gameskill != sk_nightmare) {
      
      // 'dqd' cheat for toggleable god mode
      if (cht_CheckCheat(&cheat_god, c/*ev->data1*/))
      {
	plyr->cheats ^= CF_GODMODE;
	if (plyr->cheats & CF_GODMODE)
	{
	  if (plyr->mo)
	    plyr->mo->health = 100;
	  
	  plyr->health = 100;
	  plyr->message = STSTR_DQDON;
	}
	else 
	  plyr->message = STSTR_DQDOFF;
      }
      // 'fa' cheat for killer fucking arsenal
      else if (cht_CheckCheat(&cheat_ammonokey, c/*ev->data1*/))
      {
	plyr->armorpoints = 200;
	plyr->armortype = 2;
	
	for (i=0;i<NUMWEAPONS;i++)
	  plyr->weaponowned[i] = true;
	
	for (i=0;i<NUMAMMO;i++)
	  plyr->ammo[i] = plyr->maxammo[i];
	
	plyr->message = STSTR_FAADDED;
      }
      // 'kfa' cheat for key full ammo
      else if (cht_CheckCheat(&cheat_ammo, c/*ev->data1*/))
      {
	plyr->armorpoints = 200;
	plyr->armortype = 2;
	
	for (i=0;i<NUMWEAPONS;i++)
	  plyr->weaponowned[i] = true;
	
	for (i=0;i<NUMAMMO;i++)
	  plyr->ammo[i] = plyr->maxammo[i];
	
	for (i=0;i<NUMCARDS;i++)
	  plyr->cards[i] = true;
	
	plyr->message = STSTR_KFAADDED;
      }
      // 'mus' cheat for changing music
      else if (cht_CheckCheat(&cheat_mus, c/*ev->data1*/))
      {
	
	char	buf[3];
	int		musnum;
	
	plyr->message = STSTR_MUS;
	cht_GetParam(&cheat_mus, buf);
	
	if (gamemode == commercial)
	{
	  musnum = mus_runnin + (buf[0]-'0')*10 + buf[1]-'0' - 1;
	  
	  if (((buf[0]-'0')*10 + buf[1]-'0') > 35)
	    plyr->message = STSTR_NOMUS;
	  else
	    S_ChangeMusic(musnum, 1);
	}
	else
	{
	  musnum = mus_e1m1 + (buf[0]-'1')*9 + (buf[1]-'1');
	  
	  if (((buf[0]-'1')*9 + buf[1]-'1') > 31)
	    plyr->message = STSTR_NOMUS;
	  else
	    S_ChangeMusic(musnum, 1);
	}
      }
      // Simplified, accepting both "noclip" and "idspispopd".
      // no clipping mode cheat
      else if ( cht_CheckCheat(&cheat_noclip, c/*ev->data1*/) 
		|| cht_CheckCheat(&cheat_commercial_noclip, c/*ev->data1*/) )
      {	
	plyr->cheats ^= CF_NOCLIP;
	
	if (plyr->cheats & CF_NOCLIP)
	  plyr->message = STSTR_NCON;
	else
	  plyr->message = STSTR_NCOFF;
      }
      // 'behold?' power-up cheats
      for (i=0;i<6;i++)
      {
	if (cht_CheckCheat(&cheat_powerup[i], c/*ev->data1*/))
	{
	  if (!plyr->powers[i])
	    P_GivePower( plyr, i);
	  else if (i!=pw_strength)
	    plyr->powers[i] = 1;
	  else
	    plyr->powers[i] = 0;
	  
	  plyr->message = STSTR_BEHOLDX;
	}
      }
      
      // 'behold' power-up menu
      if (cht_CheckCheat(&cheat_powerup[6], c/*ev->data1*/))
      {
	plyr->message = STSTR_BEHOLD;
      }
      // 'choppers' invulnerability & chainsaw
      else if (cht_CheckCheat(&cheat_choppers, c/*ev->data1*/))
      {
	plyr->weaponowned[wp_chainsaw] = true;
	plyr->powers[pw_invulnerability] = true;
	plyr->message = STSTR_CHOPPERS;
      }
      // 'mypos' for player position
      else if (cht_CheckCheat(&cheat_mypos, c/*ev->data1*/))
      {
	static char	buf[ST_MSGWIDTH];
	sprintf(buf, "ang=0x%x;x,y=(0x%x,0x%x)",
		players[consoleplayer].mo->angle,
		players[consoleplayer].mo->x,
		players[consoleplayer].mo->y);
	plyr->message = buf;
      }
    }
    
    // 'clev' change-level cheat
    if (cht_CheckCheat(&cheat_clev, c/*ev->data1*/))
    {
      char		buf[3];
      int		epsd;
      int		map;
      
      cht_GetParam(&cheat_clev, buf);
      
      if (gamemode == commercial)
      {
	epsd = 1/*0*/;
	map = (buf[0] - '0')*10 + buf[1] - '0';
      }
      else
      {
	epsd = buf[0] - '0';
	map = buf[1] - '0';
      }

      // Catch invalid maps.
      if (epsd < 1)
	return false;

      if (map < 1)
	return false;
      
      // Ohmygod - this is not going to work.
      if ((gamemode == retail)
	  && ((epsd > 4) || (map > 9)))
	return false;

      if ((gamemode == registered)
	  && ((epsd > 3) || (map > 9)))
	return false;

      if ((gamemode == shareware)
	  && ((epsd > 1) || (map > 9)))
	return false;

      if ((gamemode == commercial)
	&& (( epsd > 1) || (map > 34)))
	return false;

      // So be it.
      plyr->message = STSTR_CLEV;
      G_DeferedInitNew(gameskill, epsd, map);
    }

    // @'idfim' finaleĂяo`[g
    if (cht_CheckCheat(&cheat_fin, c/*ev->data1*/))
    {
        if (gamemode == commercial)
        {
            if (gamemap <= 6)
                gamemap = 6;
            else if (gamemap <= 11)
                gamemap = 11;
            else if (gamemap <= 15)
                gamemap = 15;
            else if (gamemap <= 20)
                gamemap = 20;
            else if (gamemap <= 30)
                gamemap = 30;
            else
                gamemap = 31;
        }

        F_StartFinale();
    }
  }

	return false;
}

int ST_calcPainOffset(void)
{
    int		health;
    static int	lastcalc;
    static int	oldhealth = -1;
    
    health = plyr->health > 100 ? 100 : plyr->health;

    if (health != oldhealth)
    {
	lastcalc = ST_FACESTRIDE * (((100 - health) * ST_NUMPAINFACES) / 101);
	oldhealth = health;
    }
    return lastcalc;
}

//
// This is a not-very-pretty routine which handles
//  the face states and their timing.
// the precedence of expressions is:
//  dead > evil grin > turned head > straight ahead
//
void ST_updateFaceWidget(void)
{
    int		i;
    angle_t	badguyangle;
    angle_t	diffang;
    static int	lastattackdown = -1;
    static int	priority = 0;
    boolean	doevilgrin;

    if (priority < 10)
    {
	// dead
	if (!plyr->health)
	{
	    priority = 9;
	    st_faceindex = ST_DEADFACE;
	    st_facecount = 1;
	}
    }

    if (priority < 9)
    {
	if (plyr->bonuscount)
	{
	    // picking up bonus
	    doevilgrin = false;

	    for (i=0;i<NUMWEAPONS;i++)
	    {
		if (oldweaponsowned[i] != plyr->weaponowned[i])
		{
		    doevilgrin = true;
		    oldweaponsowned[i] = plyr->weaponowned[i];
		}
	    }
	    if (doevilgrin) 
	    {
		// evil grin if just picked up weapon
		priority = 8;
		st_facecount = ST_EVILGRINCOUNT;
		st_faceindex = ST_calcPainOffset() + ST_EVILGRINOFFSET;
	    }
	}

    }
  
    if (priority < 8)
    {
	if (plyr->damagecount
	    && plyr->attacker
	    && plyr->attacker != plyr->mo)
	{
	    // being attacked
	    priority = 7;
	    
	    if (plyr->health - st_oldhealth > ST_MUCHPAIN)
	    {
		st_facecount = ST_TURNCOUNT;
		st_faceindex = ST_calcPainOffset() + ST_OUCHOFFSET;
	    }
	    else
	    {
		badguyangle = R_PointToAngle2(plyr->mo->x,
					      plyr->mo->y,
					      plyr->attacker->x,
					      plyr->attacker->y);
		
		if (badguyangle > plyr->mo->angle)
		{
		    // whether right or left
		    diffang = badguyangle - plyr->mo->angle;
		    i = diffang > ANG180; 
		}
		else
		{
		    // whether left or right
		    diffang = plyr->mo->angle - badguyangle;
		    i = diffang <= ANG180; 
		} // confusing, aint it?

		
		st_facecount = ST_TURNCOUNT;
		st_faceindex = ST_calcPainOffset();
		
		if (diffang < ANG45)
		{
		    // head-on    
		    st_faceindex += ST_RAMPAGEOFFSET;
		}
		else if (i)
		{
		    // turn face right
		    st_faceindex += ST_TURNOFFSET;
		}
		else
		{
		    // turn face left
		    st_faceindex += ST_TURNOFFSET+1;
		}
	    }
	}
    }
  
    if (priority < 7)
    {
	// getting hurt because of your own damn stupidity
	if (plyr->damagecount)
	{
	    if (plyr->health - st_oldhealth > ST_MUCHPAIN)
	    {
		priority = 7;
		st_facecount = ST_TURNCOUNT;
		st_faceindex = ST_calcPainOffset() + ST_OUCHOFFSET;
	    }
	    else
	    {
		priority = 6;
		st_facecount = ST_TURNCOUNT;
		st_faceindex = ST_calcPainOffset() + ST_RAMPAGEOFFSET;
	    }

	}

    }
  
    if (priority < 6)
    {
	// rapid firing
	if (plyr->attackdown)
	{
	    if (lastattackdown==-1)
		lastattackdown = ST_RAMPAGEDELAY;
	    else if (!--lastattackdown)
	    {
		priority = 5;
		st_faceindex = ST_calcPainOffset() + ST_RAMPAGEOFFSET;
		st_facecount = 1;
		lastattackdown = 1;
	    }
	}
	else
	    lastattackdown = -1;

    }
  
    if (priority < 5)
    {
	// invulnerability
	if ((plyr->cheats & CF_GODMODE)
	    || plyr->powers[pw_invulnerability])
	{
	    priority = 4;

	    st_faceindex = ST_GODFACE;
	    st_facecount = 1;

	}

    }

    // look left or look right if the facecount has timed out
    if (!st_facecount)
    {
	st_faceindex = ST_calcPainOffset() + (st_randomnumber % 3);
	st_facecount = ST_STRAIGHTFACECOUNT;
	priority = 0;
    }

    st_facecount--;

}

void ST_updateWidgets(void)
{
    static int	largeammo = 1994; // means "n/a"
    int		i;

    // must redirect the pointer if the ready weapon has changed.
    //  if (w_ready.data != plyr->readyweapon)
    //  {
    if (weaponinfo[plyr->readyweapon].ammo == am_noammo)
	w_ready.num = &largeammo;
    else
	w_ready.num = &plyr->ammo[weaponinfo[plyr->readyweapon].ammo];
    //{
    // static int tic=0;
    // static int dir=-1;
    // if (!(tic&15))
    //   plyr->ammo[weaponinfo[plyr->readyweapon].ammo]+=dir;
    // if (plyr->ammo[weaponinfo[plyr->readyweapon].ammo] == -100)
    //   dir = 1;
    // tic++;
    // }
    w_ready.data = plyr->readyweapon;

    // if (*w_ready.on)
    //  STlib_updateNum(&w_ready, true);
    // refresh weapon change
    //  }

    // update keycard multiple widgets
    for (i=0;i<3;i++)
    {
	keyboxes[i] = plyr->cards[i] ? i : -1;

	if (plyr->cards[i+3])
	    keyboxes[i] = i+3;
    }

    // refresh everything if this is him coming back to life
    ST_updateFaceWidget();

    // used by the w_armsbg widget
    st_notdeathmatch = !deathmatch;
    
    // used by w_arms[] widgets
    st_armson = st_statusbaron && !deathmatch; 

    // used by w_frags widget
    st_fragson = deathmatch && st_statusbaron; 
    st_fragscount = 0;

    for (i=0 ; i<MAXPLAYERS ; i++)
    {
	if (i != consoleplayer)
	    st_fragscount += plyr->frags[i];
	else
	    st_fragscount -= plyr->frags[i];
    }
/*
    // get rid of chat window if up because of message
    if (!--st_msgcounter)
	st_chat = st_oldchat;*/

}

void ST_Ticker (void)
{

    //st_clock++;
    st_randomnumber = M_Random();
    ST_updateWidgets();
    st_oldhealth = plyr->health;

}

// Palette indices.
// For damage/bonus red-/gold-shifts
#define STARTREDPALS		1
#define STARTBONUSPALS		9
#define NUMREDPALS			8
#define NUMBONUSPALS		4
// Radiation suit, green shift.
#define RADIATIONPAL		13

//static int st_palette = 0;
extern double   ortholeft;
extern double   orthoright;

void ST_doPaletteStuff(void)
{

    int		palette;
    //byte*	pal;
    int		cnt;
    int		bzc;
    byte    red, green, blue, alpha;

    cnt = plyr->damagecount;

    if (plyr->powers[pw_strength])
    {
	// slowly fade the berzerk out
  	bzc = 12 - (plyr->powers[pw_strength]>>6);

	if (bzc > cnt)
	    cnt = bzc;
    }
	
    if (cnt)
    {
	palette = (cnt+7)>>3;
	
	if (palette >= NUMREDPALS)
	    palette = NUMREDPALS-1;

	palette += STARTREDPALS;
    }

    else if (plyr->bonuscount)
    {
	palette = (plyr->bonuscount+7)>>3;

	if (palette >= NUMBONUSPALS)
	    palette = NUMBONUSPALS-1;

	palette += STARTBONUSPALS;
    }

    else if ( plyr->powers[pw_ironfeet] > 4*32
	      || plyr->powers[pw_ironfeet]&8)
	palette = RADIATIONPAL;
    else
	palette = 0;

    if (1/*palette != st_palette*/)
    {
	//st_palette = palette;
	//pal = (byte *) W_CacheLumpNum (lu_palette, PU_CACHE)+palette*768;
	//I_SetPalette (pal);
    
        if (palette == 0)
            return;
        else if (palette < STARTBONUSPALS)
        {
            red = 255;
            green = 0;
            blue = 0;
            alpha = palette<<5 - 1;
        } else if (palette < RADIATIONPAL)
        {
            red = 255;
            green = 215;
            blue = 0;
            alpha = (palette-(STARTBONUSPALS-1))<<5 - 1;
        } else
        {
            red = 0;
            green = 255;
            blue = 0;
            alpha = 80;
        }

        glColor4ub(red, green, blue, alpha);
        glBindTexture(GL_TEXTURE_2D, 0);
	    glBegin(GL_QUADS);
		    glVertex2d(ortholeft, 0);
		    glVertex2d(ortholeft, 200);
		    glVertex2d(orthoright, 200);
		    glVertex2d(orthoright, 0);
	    glEnd();
    }

}

void ST_drawWidgets(boolean refresh)
{
    int		i;

    // used by w_arms[] widgets
    st_armson = st_statusbaron && !deathmatch;

    // used by w_frags widget
    st_fragson = deathmatch && st_statusbaron; 

    STlib_updateNum(&w_ready, refresh);

    for (i=0;i<4;i++)
    {
	STlib_updateNum(&w_ammo[i], refresh);
	STlib_updateNum(&w_maxammo[i], refresh);
    }

    STlib_updatePercent(&w_health, refresh);
    STlib_updatePercent(&w_armor, refresh);

    STlib_updateBinIcon(&w_armsbg, refresh);

    for (i=0;i<6;i++)
	STlib_updateMultIcon(&w_arms[i], refresh);

    STlib_updateMultIcon(&w_faces, refresh);

    for (i=0;i<3;i++)
	STlib_updateMultIcon(&w_keyboxes[i], refresh);

    //STlib_updateNum(&w_frags, refresh);

}

int specmode;
extern GLuint   facehealthbg;
extern GLuint   armorkeybg;
extern GLuint   readyarmsbg;
extern GLuint   ammobg;
extern GLuint   redcross;
extern GLuint   shield;
int invert;

void ST_drawWidgetsSP(void)
{
    patch_t* patch;
    float x1, y1, x2, y2, s = 0.666f;
    st_number_t* n;
    int num, i;
    float w, h;
    float frameleft = (float)ortholeft;
    float frameright = (float)orthoright;
    float frametop = 0;
    float framebottom = 200.0f;

    invert = 1;

    x1 = frameleft;
    y1 = frametop;
    x2 = x1 + 93*s;
    y2 = y1 + 32*s;
    //glColor4ub(255, 255, 255, 128);
    V_DrawRect(x1, y1, x2, y2, facehealthbg);
    //glColor4ub(255, 255, 255, 255);

    patch = w_faces.p[*(w_faces.inum)];
    x1 = frameleft + 1.0f*s - patch->leftoffset*s;
    y1 = frametop - patch->topoffset*s;
    x2 = x1 + patch->width*s;
    y2 = y1 + patch->height*s;
    V_StretchDrawPatch(x1, y1, x2, y2, patch);

    patch = w_health.p;
    x1 = frameleft + (ST_HEALTHX - 12.0f)*s;
    y1 = frametop + (ST_HEALTHY - 168.0f)*s;
    x2 = x1 + patch->width*s;
    y2 = y1 + patch->height*s;
    V_StretchDrawPatch(x1, y1, x2, y2, patch); // @STTPRCNTLeft/TopItZbg͋0
    n = &w_health.n;
    num = *(n->num);
    patch = n->p[0];
    w = patch->width*s;
    for (i=0 ; i<3 ; i++)
    {
        patch = n->p[num%10];
        x1 -= w;
        x2 = x1 + patch->width*s;
        V_StretchDrawPatch(x1 - patch->leftoffset*s, y1, x2 - patch->leftoffset*s, y2, patch); // @tallnum(STTNUM#)TopItZbgׂ͂0
        num /= 10;
        if (!num)
            break;
    }
/*
    n = &w_health.n;
    num = *(n->num);
    patch = n->p[0];

    x1 = frameleft;
    y1 = frametop + 32*s + 1.0f;
    x2 = x1 + 35*s;
    y2 = y1 + patch->height*0.333f + 1.0f;
    V_DrawBackground(x1, y1, x2, y2, 255, 255, 255, 64);

    x2 = x1 + (y2 - y1)*(240.0f/200.0f);
    V_DrawRect(x1, y1, x2, y2, redcross); // @shieldłmFς

    x1 = x1 + 35*s - 1.0f;
    y1 = y1 + 0.5f;
    y2 = y1 + patch->height*0.333f;
    w = patch->width*0.333f;
    for (i=0 ; i<3 ; i++)
    {
        patch = n->p[num%10];
        x1 -= w;
        x2 = x1 + patch->width*0.333f;
        V_StretchDrawPatch(x1 - patch->leftoffset*0.333f, y1, x2 - patch->leftoffset*0.333f, y2, patch);
        num /= 10;
        if (!num)
            break;
    }
*/
    x2 = frameright;
    y1 = frametop;
    x1 = x2 - 71*s;
    y2 = y1 + 32*s;
    //glColor4ub(255, 255, 255, 128);
    V_DrawRect(x1, y1, x2, y2, armorkeybg);
    //glColor4ub(255, 255, 255, 255);

    patch = w_armor.p;
    x1 = frameright - (249.0f - ST_ARMORX)*s;
    y1 = frametop + (ST_ARMORY - 168.0f)*s;
    x2 = x1 + patch->width*s;
    y2 = y1 + patch->height*s;
    V_StretchDrawPatch(x1, y1, x2, y2, patch); // @STTPRCNTLeft/TopItZbg͋0
    n = &w_armor.n;
    num = *(n->num);
    patch = n->p[0];
    w = patch->width*s;
    for (i=0 ; i<3 ; i++)
    {
        patch = n->p[num%10];
        x1 -= w;
        x2 = x1 + patch->width*s;
        V_StretchDrawPatch(x1 - patch->leftoffset*s, y1, x2 - patch->leftoffset*s, y2, patch); // @tallnum(STTNUM#)TopItZbgׂ͂0
        num /= 10;
        if (!num)
            break;
    }

    if (*(w_keyboxes[0].inum) != -1)
    {
        patch = w_keyboxes[0].p[*(w_keyboxes[0].inum)];
        x1 = frameright - (249.0f - ST_KEY0X)*s - patch->leftoffset*s;
        y1 = frametop + (ST_KEY0Y - 168.0f)*s - patch->topoffset*s;
        x2 = x1 + patch->width*s;
        y2 = y1 + patch->height*s;
        V_StretchDrawPatch(x1, y1, x2, y2, patch);
    }

    if (*(w_keyboxes[1].inum) != -1)
    {
        patch = w_keyboxes[1].p[*(w_keyboxes[1].inum)];
        x1 = frameright - (249.0f - ST_KEY1X)*s - patch->leftoffset*s;
        y1 = frametop + (ST_KEY1Y - 168.0f)*s - patch->topoffset*s;
        x2 = x1 + patch->width*s;
        y2 = y1 + patch->height*s;
        V_StretchDrawPatch(x1, y1, x2, y2, patch);
    }

    if (*(w_keyboxes[2].inum) != -1)
    {
        patch = w_keyboxes[2].p[*(w_keyboxes[2].inum)];
        x1 = frameright - (249.0f - ST_KEY2X)*s - patch->leftoffset*s;
        y1 = frametop + (ST_KEY2Y - 168.0f)*s - patch->topoffset*s;
        x2 = x1 + patch->width*s;
        y2 = y1 + patch->height*s;
        V_StretchDrawPatch(x1, y1, x2, y2, patch);
    }

    invert = -1;

    x1 = frameleft;
    y1 = framebottom - 32*s;
    x2 = x1 + 85*s;
    y2 = y1 + 32*s;
    //glColor4ub(255, 255, 255, 128);
    V_DrawRect(x1, y1, x2, y2, readyarmsbg);
    //glColor4ub(255, 255, 255, 255);

    n = &w_ready;
    num = *(n->num);
    if (num == 1994)
        goto skip;
    patch = n->p[0];
    w = patch->width*s;
    x1 = frameleft + ST_AMMOX*s;
    y1 = framebottom - (200.0f - ST_AMMOY)*s;
    y2 = y1 + patch->height*s;
    for (i=0 ; i<3 ; i++)
    {
        patch = n->p[num%10];
        x1 -= w;
        x2 = x1 + patch->width*s;
        V_StretchDrawPatch(x1 - patch->leftoffset*s, y1, x2 - patch->leftoffset*s, y2, patch);
        num /= 10;
        if (!num)
            break;
    }

skip:
    for (i=0 ; i<6 ; i++)
    {
        patch = w_arms[i].p[*(w_arms[i].inum)];
        x1 = frameleft + 46*s + (ST_ARMSX - ST_ARMSBGX)*s + (i%3)*ST_ARMSXSPACE*s;
        y1 = framebottom - (200.0f - ST_ARMSY)*s + (i/3)*ST_ARMSYSPACE*s;
        x2 = x1 + patch->width*s;
        y2 = y1 + patch->height*s;
        V_StretchDrawPatch(x1, y1, x2, y2, patch);
    }

    x2 = frameright;
    y2 = framebottom;
    x1 = x2 - 71*s;
    y1 = y2 - 32*s;
    //glColor4ub(255, 255, 255, 128);
    V_DrawRect(x1, y1, x2, y2, ammobg);
    //glColor4ub(255, 255, 255, 255);

    // @shortnum(STYSNUM#)09܂łׂĕ4̍6(Left/TopItZbgׂ0)
    w = shortnum[0]->width*s;
    h = shortnum[0]->height*s;

    /*if (weaponinfo[plyr->readyweapon].ammo == am_clip)
        glColor4ub(255, 255, 255, 255);
    else
        glColor4ub(128, 128, 128, 255);*/
    num = *(w_ammo[0].num);
    x1 = frameright - (320.0f - ST_AMMO0X)*s;
    y1 = framebottom - (200.0f - ST_AMMO0Y)*s;
    y2 = y1 + h;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }
    num = *(w_maxammo[0].num);
    x1 = frameright - (320.0f - ST_MAXAMMO0X)*s;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }

    /*if (weaponinfo[plyr->readyweapon].ammo == am_shell)
        glColor4ub(255, 255, 255, 255);
    else
        glColor4ub(128, 128, 128, 255);*/
    num = *(w_ammo[1].num);
    x1 = frameright - (320.0f - ST_AMMO1X)*s;
    y1 = framebottom - (200.0f - ST_AMMO1Y)*s;
    y2 = y1 + h;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }
    num = *(w_maxammo[1].num);
    x1 = frameright - (320.0f - ST_MAXAMMO1X)*s;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }

    /*if (weaponinfo[plyr->readyweapon].ammo == am_misl)
        glColor4ub(255, 255, 255, 255);
    else
        glColor4ub(128, 128, 128, 255);*/
    num = *(w_ammo[2].num);
    x1 = frameright - (320.0f - ST_AMMO2X)*s;
    y1 = framebottom - (200.0f - ST_AMMO2Y)*s;
    y2 = y1 + h;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }
    num = *(w_maxammo[2].num);
    x1 = frameright - (320.0f - ST_MAXAMMO2X)*s;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }

    /*if (weaponinfo[plyr->readyweapon].ammo == am_cell)
        glColor4ub(255, 255, 255, 255);
    else
        glColor4ub(128, 128, 128, 255);*/
    num = *(w_ammo[3].num);
    x1 = frameright - (320.0f - ST_AMMO3X)*s;
    y1 = framebottom - (200.0f - ST_AMMO3Y)*s;
    y2 = y1 + h;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }
    num = *(w_maxammo[3].num);
    x1 = frameright - (320.0f - ST_MAXAMMO3X)*s;
    for (i=0 ; i<3 ; i++)
    {
        x2 = x1;
        x1 -= w;
        V_StretchDrawPatch(x1, y1, x2, y2, shortnum[num%10]);
        num /= 10;
        if (!num)
            break;
    }

    //glColor4ub(255, 255, 255, 255);
}

void ST_Drawer (boolean fullscreen/*, boolean refresh*/)
{
    if (plyr->fixedcolormap == INVERSECOLORMAP)
    {
        glBlendFunc(GL_ONE_MINUS_DST_COLOR, GL_ZERO);
        glColor4ub(255, 255, 255, 255);
        glBindTexture(GL_TEXTURE_2D, 0);
	    glBegin(GL_QUADS);
		    glVertex2d(ortholeft, 0);
		    glVertex2d(ortholeft, 200);
		    glVertex2d(orthoright, 200);
		    glVertex2d(orthoright, 0);
	    glEnd();
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    }

    if (specmode)
        ST_drawWidgetsSP();

    if (fullscreen || specmode)
        //return;
        goto skip;

    V_DrawPatch(ST_X, ST_Y/*0*/, BG, sbar);
	if (netgame)
	    V_DrawPatch(ST_FX, ST_Y/*0*/, BG, faceback);

    // update all widgets
    ST_drawWidgets(false);

skip:
    if (plyr->fixedcolormap == INVERSECOLORMAP)
        return;

    // Do red-/gold-shifts from damage/items
    ST_doPaletteStuff();
    glColor4ub(255, 255, 255, 255);
}

void ST_loadGraphics(void)
{

    int		i;
    int		j;
    int		facenum;
    
    char	namebuf[9];

    // Load the numbers, tall and short
    for (i=0;i<10;i++)
    {
	sprintf(namebuf, "STTNUM%d", i);
	tallnum[i] = (patch_t *) W_CacheLumpName(namebuf, PU_STATIC);

	sprintf(namebuf, "STYSNUM%d", i);
	shortnum[i] = (patch_t *) W_CacheLumpName(namebuf, PU_STATIC);
    }

    // Load percent key.
    //Note: why not load STMINUS here, too?
    tallpercent = (patch_t *) W_CacheLumpName("STTPRCNT", PU_STATIC);

    // key cards
    for (i=0;i<NUMCARDS/*6*/;i++)
    {
	sprintf(namebuf, "STKEYS%d", i);
	keys[i] = (patch_t *) W_CacheLumpName(namebuf, PU_STATIC);
    }

    // arms background
    armsbg = (patch_t *) W_CacheLumpName("STARMS", PU_STATIC);

    // arms ownership widgets
    for (i=0;i<6;i++)
    {
	sprintf(namebuf, "STGNUM%d", i+2);

	// gray #
	arms[i][0] = (patch_t *) W_CacheLumpName(namebuf, PU_STATIC);

	// yellow #
	arms[i][1] = shortnum[i+2]; 
    }

    // face backgrounds for different color players
    sprintf(namebuf, "STFB%d", consoleplayer);
    faceback = (patch_t *) W_CacheLumpName(namebuf, PU_STATIC);

    // status bar background bits
    sbar = (patch_t *) W_CacheLumpName("STBAR", PU_STATIC);

    // face states
    facenum = 0;
    for (i=0;i<ST_NUMPAINFACES;i++)
    {
	for (j=0;j<ST_NUMSTRAIGHTFACES;j++)
	{
	    sprintf(namebuf, "STFST%d%d", i, j);
	    faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
	}
	sprintf(namebuf, "STFTR%d0", i);	// turn right
	faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
	sprintf(namebuf, "STFTL%d0", i);	// turn left
	faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
	sprintf(namebuf, "STFOUCH%d", i);	// ouch!
	faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
	sprintf(namebuf, "STFEVL%d", i);	// evil grin ;)
	faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
	sprintf(namebuf, "STFKILL%d", i);	// pissed off
	faces[facenum++] = W_CacheLumpName(namebuf, PU_STATIC);
    }
    faces[facenum++] = W_CacheLumpName("STFGOD0", PU_STATIC);
    faces[facenum++] = W_CacheLumpName("STFDEAD0", PU_STATIC);

}

void ST_createWidgets(void)
{

    int i;

    // ready weapon ammo
    STlib_initNum(&w_ready,
		  ST_AMMOX,
		  ST_AMMOY,
		  tallnum,
		  &plyr->ammo[weaponinfo[plyr->readyweapon].ammo],
		  &st_statusbaron,
		  ST_AMMOWIDTH );

    // the last weapon type
    w_ready.data = plyr->readyweapon; 

    // health percentage
    STlib_initPercent(&w_health,
		      ST_HEALTHX,
		      ST_HEALTHY,
		      tallnum,
		      &plyr->health,
		      &st_statusbaron,
		      tallpercent);

    // arms background
    STlib_initBinIcon(&w_armsbg,
		      ST_ARMSBGX,
		      ST_ARMSBGY,
		      armsbg,
		      &st_notdeathmatch,
		      &st_statusbaron);

    // weapons owned
    for(i=0;i<6;i++)
    {
	STlib_initMultIcon(&w_arms[i],
			   ST_ARMSX+(i%3)*ST_ARMSXSPACE,
			   ST_ARMSY+(i/3)*ST_ARMSYSPACE,
			   arms[i], (int *) &plyr->weaponowned[i+1],
			   &st_armson);
    }

    // frags sum
    STlib_initNum(&w_frags,
		  ST_FRAGSX,
		  ST_FRAGSY,
		  tallnum,
		  &st_fragscount,
		  &st_fragson,
		  ST_FRAGSWIDTH);

    // faces
    STlib_initMultIcon(&w_faces,
		       ST_FACESX,
		       ST_FACESY,
		       faces,
		       &st_faceindex,
		       &st_statusbaron);

    // armor percentage - should be colored later
    STlib_initPercent(&w_armor,
		      ST_ARMORX,
		      ST_ARMORY,
		      tallnum,
		      &plyr->armorpoints,
		      &st_statusbaron, tallpercent);

    // keyboxes 0-2
    STlib_initMultIcon(&w_keyboxes[0],
		       ST_KEY0X,
		       ST_KEY0Y,
		       keys,
		       &keyboxes[0],
		       &st_statusbaron);
    
    STlib_initMultIcon(&w_keyboxes[1],
		       ST_KEY1X,
		       ST_KEY1Y,
		       keys,
		       &keyboxes[1],
		       &st_statusbaron);

    STlib_initMultIcon(&w_keyboxes[2],
		       ST_KEY2X,
		       ST_KEY2Y,
		       keys,
		       &keyboxes[2],
		       &st_statusbaron);

    // ammo count (all four kinds)
    STlib_initNum(&w_ammo[0],
		  ST_AMMO0X,
		  ST_AMMO0Y,
		  shortnum,
		  &plyr->ammo[0],
		  &st_statusbaron,
		  ST_AMMO0WIDTH);

    STlib_initNum(&w_ammo[1],
		  ST_AMMO1X,
		  ST_AMMO1Y,
		  shortnum,
		  &plyr->ammo[1],
		  &st_statusbaron,
		  ST_AMMO1WIDTH);

    STlib_initNum(&w_ammo[2],
		  ST_AMMO2X,
		  ST_AMMO2Y,
		  shortnum,
		  &plyr->ammo[2],
		  &st_statusbaron,
		  ST_AMMO2WIDTH);
    
    STlib_initNum(&w_ammo[3],
		  ST_AMMO3X,
		  ST_AMMO3Y,
		  shortnum,
		  &plyr->ammo[3],
		  &st_statusbaron,
		  ST_AMMO3WIDTH);

    // max ammo count (all four kinds)
    STlib_initNum(&w_maxammo[0],
		  ST_MAXAMMO0X,
		  ST_MAXAMMO0Y,
		  shortnum,
		  &plyr->maxammo[0],
		  &st_statusbaron,
		  ST_MAXAMMO0WIDTH);

    STlib_initNum(&w_maxammo[1],
		  ST_MAXAMMO1X,
		  ST_MAXAMMO1Y,
		  shortnum,
		  &plyr->maxammo[1],
		  &st_statusbaron,
		  ST_MAXAMMO1WIDTH);

    STlib_initNum(&w_maxammo[2],
		  ST_MAXAMMO2X,
		  ST_MAXAMMO2Y,
		  shortnum,
		  &plyr->maxammo[2],
		  &st_statusbaron,
		  ST_MAXAMMO2WIDTH);
    
    STlib_initNum(&w_maxammo[3],
		  ST_MAXAMMO3X,
		  ST_MAXAMMO3Y,
		  shortnum,
		  &plyr->maxammo[3],
		  &st_statusbaron,
		  ST_MAXAMMO3WIDTH);

}

void ST_initData(void)
{

    int		i;

    //st_firsttime = true;
    plyr = &players[consoleplayer];
/*
    st_clock = 0;
    st_chatstate = StartChatState;
    st_gamestate = FirstPersonState;

    st_statusbaron = true;
    st_oldchat = st_chat = false;
    st_cursoron = false;
*/
    st_faceindex = 0;
    //st_palette = -1;

    st_oldhealth = -1;

    for (i=0;i<NUMWEAPONS;i++)
	oldweaponsowned[i] = plyr->weaponowned[i];

    for (i=0;i<3;i++)
	keyboxes[i] = -1;

    STlib_init();

}

void ST_Start (void)
{
    ST_initData();
    ST_createWidgets();   
}

void ST_Init (void)
{
    ST_loadGraphics();
/*
    veryfirsttime = 0;
    ST_loadData();
    screens[4] = (byte *) Z_Malloc(ST_WIDTH*ST_HEIGHT, PU_STATIC, 0);*/
}
