#include <windows.h>

unsigned* AddBorderToImage(unsigned* data, int width, int height, int border)
{
    unsigned*   newdata;
    int         x, y;

    newdata = (unsigned *)calloc((width+2*border)*(height+2*border), 4);

    for (y=0 ; y<height ; y++)
        for (x=0 ; x<width ; x++)
            newdata[(y+border)*(width+2*border) + (x+border)] = data[y*width + x];

    free(data);

    return newdata;
}

unsigned* FillBlankPixelsWithAdjacentColors(unsigned* data, int width, int height)
{
    unsigned*   newdata;
    int         x, y;
    byte*       pixel;
    int         r, g, b, num;

    newdata = (unsigned *)calloc(width*height, 4);
    memcpy(newdata, data, width*height*4);

    for (y=0 ; y<height ; y++)
    {
        for (x=0 ; x<width ; x++)
        {
            pixel = (byte *)&data[y*width + x];
            if (pixel[3])
                continue;

            r = g = b = num = 0;

            if (y > 0)
            {
                if (x > 0)
                {
                    pixel = (byte *)&data[(y-1)*width + (x-1)];
                    if (pixel[3])
                    {
                        r += pixel[0];
                        g += pixel[1];
                        b += pixel[2];
                        num++;
                    }
                }

                pixel = (byte *)&data[(y-1)*width + x];
                if (pixel[3])
                {
                    r += pixel[0];
                    g += pixel[1];
                    b += pixel[2];
                    num++;
                }

                if (x < (width-1))
                {
                    pixel = (byte *)&data[(y-1)*width + (x+1)];
                    if (pixel[3])
                    {
                        r += pixel[0];
                        g += pixel[1];
                        b += pixel[2];
                        num++;
                    }
                }
            }

            if (x > 0)
            {
                pixel = (byte *)&data[y*width + (x-1)];
                if (pixel[3])
                {
                    r += pixel[0];
                    g += pixel[1];
                    b += pixel[2];
                    num++;
                }
            }

            if (x < (width-1))
            {
                pixel = (byte *)&data[y*width + (x+1)];
                if (pixel[3])
                {
                    r += pixel[0];
                    g += pixel[1];
                    b += pixel[2];
                    num++;
                }
            }

            if (y < (height-1))
            {
                if (x > 0)
                {
                    pixel = (byte *)&data[(y+1)*width + (x-1)];
                    if (pixel[3])
                    {
                        r += pixel[0];
                        g += pixel[1];
                        b += pixel[2];
                        num++;
                    }
                }

                pixel = (byte *)&data[(y+1)*width + x];
                if (pixel[3])
                {
                    r += pixel[0];
                    g += pixel[1];
                    b += pixel[2];
                    num++;
                }

                if (x < (width-1))
                {
                    pixel = (byte *)&data[(y+1)*width + (x+1)];
                    if (pixel[3])
                    {
                        r += pixel[0];
                        g += pixel[1];
                        b += pixel[2];
                        num++;
                    }
                }
            }

            if (num > 0)
            {
                pixel = (byte *)&newdata[y*width + x];
                pixel[0] = r/num;
                pixel[1] = g/num;
                pixel[2] = b/num;
            }
        }
    }

    free(data);

    return newdata;
}
