#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ
#include <gl\glu.h>
#include <stdlib.h>
#include <stdio.h>
#include "v_video.h"
#include "w_wad.h"
#include "z_zone.h"
#include "i_system.h"
#include "hu_stuff.h"
#include "m_swap.h"
#include "r_data.h"
#include "doomstat.h"
#include "m_argv.h"

int	        usegamma;
byte*		playpal;

GLuint*     texture_objects;
int         minfilter;
int         magfilter;
int         patchfilter;
int         spritefilter;
int         texfilter;
int         texborder;
GLenum      minfiltertype;
GLenum      magfiltertype;

unsigned* AddBorderToImage(unsigned* data, int width, int height, int border);
unsigned* FillBlankPixelsWithAdjacentColors(unsigned* data, int width, int height);

unsigned* ImageFileToRGBA(void* image, int size, int* width, int* height);
unsigned* BitmapResourceToRGBA(PWCHAR name, int* width, int* height);
unsigned* IconResourceToRGBA(char* name, int* pWidth, int* pHeight);

int W_CheckNumForNameInIWAD (char* name);
int iwadnumlumps;
int templumpnum;

int     zlighton;
float   zlightrange;
GLuint  zlightmap;

int shadow;
GLuint* shadow_textures;

int customsky;
GLuint sky_textures[4][4];

GLuint  facehealthbg;
GLuint  armorkeybg;
GLuint  readyarmsbg;
GLuint  ammobg;
GLuint  redcross;
GLuint  shield;

//
// Misc. patch names
//
char* mpnames[] = 
{
	"TITLEPIC",
    "HELP",
	"HELP1",
	"CREDIT",
	"HELP2",
    "M_PAUSE",

	// Menu	
	"M_LOADG",
	"M_LSLEFT",
	"M_LSCNTR",
	"M_LSRGHT",
	"M_SAVEG",
	"M_SVOL",
	"M_DOOM",
	"M_NEWG",
	"M_SKILL",
	"M_EPISOD",
	"M_OPTTTL",
	"M_GDHIGH",
	"M_GDLOW",
	"M_MSGOFF",
	"M_MSGON",
	"M_THERML",
	"M_THERMM",
	"M_THERMR",
	"M_THERMO",
	"M_CELL1", // not
	"M_CELL2", //  used?
	"M_SKULL1",
	"M_SKULL2",
	"M_NGAME",
	"M_OPTION",
	"M_RDTHIS",
	"M_QUITG",
	"M_EPI1",
	"M_EPI2",
	"M_EPI3",
	"M_EPI4",
	"M_JKILL",
	"M_ROUGH",
	"M_HURT",
	"M_ULTRA",
	"M_NMARE",
	"M_ENDGAM",
	"M_MESSG",
	"M_DETAIL",
	"M_SCRNSZ",
	"M_MSENS",
	"M_SFXVOL",
	"M_MUSVOL",

    // Status bar
    "STBAR",    // entire status bar background
    "STFST00",  // faces
    "STFST01",
    "STFST02",
    "STFST10",
    "STFST11",
    "STFST12",
    "STFST20",
    "STFST21",
    "STFST22",
    "STFST30",
    "STFST31",
    "STFST32",
    "STFST40",
    "STFST41",
    "STFST42",
    "STFTR00",
    "STFTR10",
    "STFTR20",
    "STFTR30",
    "STFTR40",
    "STFTL00",
    "STFTL10",
    "STFTL20",
    "STFTL30",
    "STFTL40",
    "STFOUCH0",
    "STFOUCH1",
    "STFOUCH2",
    "STFOUCH3",
    "STFOUCH4",
    "STFEVL0",
    "STFEVL1",
    "STFEVL2",
    "STFEVL3",
    "STFEVL4",
    "STFKILL0",
    "STFKILL1",
    "STFKILL2",
    "STFKILL3",
    "STFKILL4",
    "STFGOD0",
    "STFDEAD0",
    "STTNUM0",  // tall number
    "STTNUM1",
    "STTNUM2",
    "STTNUM3",
    "STTNUM4",
    "STTNUM5",
    "STTNUM6",
    "STTNUM7",
    "STTNUM8",
    "STTNUM9",
    "STYSNUM0", // short number. 2 to 7 are also weapon number(yellow)
    "STYSNUM1",
    "STYSNUM2",
    "STYSNUM3",
    "STYSNUM4",
    "STYSNUM5",
    "STYSNUM6",
    "STYSNUM7",
    "STYSNUM8",
    "STYSNUM9",
    "STGNUM2",  // weapon number(gray)
    "STGNUM3",
    "STGNUM4",
    "STGNUM5",
    "STGNUM6",
    "STGNUM7",
    "STKEYS0",  // key cards
    "STKEYS1",
    "STKEYS2",
    "STKEYS3",
    "STKEYS4",
    "STKEYS5",
    "STTPRCNT", // tall percent
    "STTMINUS", // minus sign
    "STARMS",   // arms background
    "STFB0",    // face backgrounds
    "STFB1",
    "STFB2",
    "STFB3",

    // Intermission 
    "INTERPIC",
    "WIMAP0",
    "WIMAP1",
    "WIMAP2",
    "WIURH0",   // you are here
    "WIURH1",   // you are here (alt.)
    "WISPLAT",  // splat
    "WIMINUS",
    "WIPCNT",
    "WIF",
    "WIENTER",
    "WIOSTK",
    "WIOSTS",
    "WISCRT2",
    "WIOBJ",
    "WIOSTI",
    "WIFRGS",
    "WICOLON",
    "WITIME",
    "WISUCKS",
    "WIPAR",
    "WIKILRS",
    "WIVCTMS",
    "WIMSTT",
    "STFST01",
    "STFDEAD0",
    "STPB0",
    "STPB1",
    "STPB2",
    "STPB3",
    "WIBP1",
    "WIBP2",
    "WIBP3",
    "WIBP4",

    // Finale
    "VICTORY2",
    "ENDPIC",
    "PFUB1",
    "PFUB2",
    "END0",
    "END1",
    "END2",
    "END3",
    "END4",
    "END5",
    "END6",
    "BOSSBACK"
};

extern int invert;

void V_StretchDrawPatch(float x1, float y1, float x2, float y2, patch_t* patch)
{
    int i;

    for (i=0 ; i<numlumps ; i++)
		if (lumpcache[i] == patch)
			break;

	if ((int)texture_objects[i] == -1 || i == numlumps)
        return;

    if (invert)
    {
        float delta = invert*(200.0f - 32*0.666f);
        y1 += delta;
        y2 += delta;
    }

    glBindTexture(GL_TEXTURE_2D, texture_objects[i]);
	glBegin(GL_QUADS);
		glTexCoord2i(0, 0);
		glVertex2f(x1, y1);
		glTexCoord2i(0, 1);
		glVertex2f(x1, y2);
		glTexCoord2i(1, 1);
		glVertex2f(x2, y2);
		glTexCoord2i(1, 0);
		glVertex2f(x2, y1);
	glEnd();
}

void V_DrawRect(float x1, float y1, float x2, float y2, GLuint tex)
{
    if (invert)
    {
        float delta = invert*(200.0f - 32*0.666f);
        y1 += delta;
        y2 += delta;
    }

    glBindTexture(GL_TEXTURE_2D, tex);
	glBegin(GL_QUADS);
		glTexCoord2i(0, 0);
		glVertex2f(x1, y1);
		glTexCoord2i(0, 1);
		glVertex2f(x1, y2);
		glTexCoord2i(1, 1);
		glVertex2f(x2, y2);
		glTexCoord2i(1, 0);
		glVertex2f(x2, y1);
	glEnd();
}

void V_DrawBackground(float x1, float y1, float x2, float y2, int r, int g, int b, int a)
{
    glColor4ub(r, g, b, a);
    glBindTexture(GL_TEXTURE_2D, 0);
    glBegin(GL_QUADS);
		glTexCoord2i(0, 0);
		glVertex2f(x1, y1);
		glTexCoord2i(0, 1);
		glVertex2f(x1, y2);
		glTexCoord2i(1, 1);
		glVertex2f(x2, y2);
		glTexCoord2i(1, 0);
		glVertex2f(x2, y1);
	glEnd();
    glColor4ub(255, 255, 255, 255);
}

void
V_DrawPatch
( int		x,
  int		y,
  int		scrn,
  patch_t*	patch ) 
{
	int     i;
    int     s1, s2;

	for (i=0 ; i<numlumps ; i++)
		if (lumpcache[i] == patch)
			break;

	if ((int)texture_objects[i] == -1 || i == numlumps)
        return;

    if (scrn == -1)
    {
        s1 = 1;
        s2 = 0;
    } else
    {
        s1 = 0;
        s2 = 1;
    }

	y -= SHORT(patch->topoffset); 
    x -= SHORT(patch->leftoffset);

	glBindTexture(GL_TEXTURE_2D, texture_objects[i]);
	glBegin(GL_QUADS);
		glTexCoord2i(s1, 0);
		glVertex2i(x, y);
		glTexCoord2i(s1, 1);
		glVertex2i(x, y+SHORT(patch->height));
		glTexCoord2i(s2, 1);
		glVertex2i(x+SHORT(patch->width), y+SHORT(patch->height));
		glTexCoord2i(s2, 0);
		glVertex2i(x+SHORT(patch->width), y);
	glEnd();
}

void
V_DrawPatchFlipped
( int		x,
  int		y,
  int		scrn,
  patch_t*	patch ) 
{
    V_DrawPatch(x, y, -1, patch);
}

void
V_DrawPatchDirect
( int		x,
  int		y,
  int		scrn,
  patch_t*	patch ) 
{
    V_DrawPatch (x,y,scrn, patch);
}

void ResampleTexture (unsigned *in, int inwidth, int inheight, unsigned *out,  int outwidth, int outheight)
{
	int		i, j, k, l;
	unsigned	*inrow;

    // V1.6 
    // @}XNt摜ɂ͂܂Ȃ
    gluScaleImage(GL_RGBA, inwidth, inheight, GL_UNSIGNED_BYTE, in, outwidth, outheight, GL_UNSIGNED_BYTE, out);
    return;

	for (i=0 ; i<outheight ; i++, out+=outwidth)
	{
		if (inheight == outheight)
			l = i;
		else
			l = (int)(i/(float)outheight*inheight); // @outheightinheightꍇ̒liɂȂ邪A_ł̒li኱Ȃꍇ͐؂艺鋰ꂪ

		inrow = in + inwidth*l;

		for (j=0 ; j<outwidth ; j++)
		{
			if (inwidth == outwidth)
				k = j;
			else
				k = (int)(j/(float)outwidth*inwidth);

			out[j] = inrow[k];
		}
	}
}

void DrawColumnInRGBA(post_t* post, byte* data, int x, int originy, int pitch, int height)
{
	int     count;
    int     toprow;
    byte*	source;
    int     i;
	byte*	dest;
	int		index;

    while (post->topdelta != 0xff)
    {
        count = post->length;
        toprow = originy + post->topdelta;
        source = (byte *)post + 3;

        if (toprow < 0) // @originy̎ɉ\
        {
            count += toprow;
            source -= toprow; 
            toprow = 0;
        }

        if (toprow + count > height)
            count = height - toprow;

        if (count > 0)
            for (i=0 ; i<count ; i++)
            {
                dest = data + 4*((toprow+i)*pitch + x);
				index = source[i];
                dest[0] = playpal[index*3];
				dest[1] = playpal[index*3+1];
				dest[2] = playpal[index*3+2];
				dest[3] = 255;
            }

        post = (post_t *)((byte *)post + post->length + 4); // @post
    }
}

//GLfloat bordercolor[4] = { 0, 0, 0, 0 };
extern int  glvers;

GLuint CreateTexureObjectFromPatch(patch_t* patch, GLenum mintype, GLenum magtype)
{
	GLuint		texture;
	int			width, height, scaled_width, scaled_height;
	unsigned	*data, *scaled_data;
	int			size, i;
	post_t*		column;
    int         border = 0;

    i = W_CheckNumForName(lumpinfo[templumpnum].name);
    if (i != -1 && i >= iwadnumlumps)
    {
        if (  *(short*)patch == 0x5089 ||   // PNG
              *(unsigned short*)patch == 0xD8FF ||  // JPG
              *(short*)patch == 0x4947 ||   // GIF
              *(short*)patch == 0x4D42      // BMP
           )
        {
            data = ImageFileToRGBA((void*)patch, W_LumpLength(templumpnum), &width, &height);
            i = W_CheckNumForNameInIWAD(lumpinfo[templumpnum].name);
            if (i != -1 && i < iwadnumlumps)
            {
                if (i < firstspritelump || i > lastspritelump) // @XvCg̃VhEeNX`鎞̂߂Ɍ̃f[^͉ϏoȂ
                {
                    void* src = W_CacheLumpNum(i, PU_CACHE);
                    memcpy((void*)patch, src, sizeof(patch_t));
                }
            }
            goto next;
        }
    }

	width = SHORT(patch->width);
	height = SHORT(patch->height);

	size = width * height * 4;
	data = calloc(size, 1);

	for (i=0 ; i<width ; i++)
	{
		column = (post_t *)((byte *)patch + patch->columnofs[i]);
        DrawColumnInRGBA(column, (byte *)data, i, 0, width, height);
    }

    if (glvers >= 2)
        goto next;

	for (scaled_width = 1 ; scaled_width < width ; scaled_width <<= 1)
		;
	for (scaled_height = 1 ; scaled_height < height ; scaled_height <<= 1)
		;

	if (width != scaled_width || height != scaled_height)
	{
		size = scaled_width * scaled_height * 4;
		scaled_data = calloc(size, 1);
		ResampleTexture(data, width, height, scaled_data, scaled_width, scaled_height);
		free(data);
		data = scaled_data;
        width = scaled_width;
        height = scaled_height;
	}

next:
    if (texborder)
    {
        data = AddBorderToImage(data, width, height, 1);
        width += 2;
        height += 2;
        border = 1;
    }
    data = FillBlankPixelsWithAdjacentColors(data, width, height);

	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, mintype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, magtype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    //glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, bordercolor);
	//glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
    //if (mintype == GL_LINEAR || mintype == GL_NEAREST)
	    glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, border, GL_RGBA, GL_UNSIGNED_BYTE, data);/*
    else
        gluBuild2DMipmaps(GL_TEXTURE_2D, 4, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);*/

	free(data);

	return texture;
}

#include "glext.h"  // @http://www.opengl.org/registry/_E[h
PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;
PFNGLMULTITEXCOORD2FARBPROC glMultiTexCoord2fARB;
int numunits;

extern HINSTANCE hInst;

//
// V_Init
// 
void V_Init (void) 
{
	int		nummpnames;
	int		size, i, j, lump;
	GLuint	texture;
    char	buffer[9];
    char	name[9];
    int     p;
    GLenum  filtertype;
/*
    p = M_CheckParm("-minfilter");
    if (p && p < myargc-1)
        minfilter = atoi(myargv[p+1]);
    p = M_CheckParm("-magfilter");
    if (p && p < myargc-1)
        magfilter = atoi(myargv[p+1]);
    p = M_CheckParm("-patchfilter");
    if (p && p < myargc-1)
        patchfilter = atoi(myargv[p+1]);
    p = M_CheckParm("-spritefilter");
    if (p && p < myargc-1)
        spritefilter = atoi(myargv[p+1]);*/
    p = M_CheckParm("-texfilter");
    if (p && p < myargc-1)
        texfilter = atoi(myargv[p+1]);
    if (texfilter)
    {
        minfilter = 5;
        magfilter = patchfilter = spritefilter = 1;
    }
    else
    {
        minfilter = magfilter = patchfilter = spritefilter = 0;
    }

    p = M_CheckParm("-texborder");
    if (p && p < myargc-1)
        texborder = atoi(myargv[p+1]);

    switch (minfilter)
    {
    case 0:
        minfiltertype = GL_NEAREST;
        break;
    case 1:
        minfiltertype = GL_LINEAR;
        break;
    case 2:
        minfiltertype = GL_NEAREST_MIPMAP_NEAREST;
        break;
    case 3:
        minfiltertype = GL_NEAREST_MIPMAP_LINEAR;
        break;
    case 4:
        minfiltertype = GL_LINEAR_MIPMAP_NEAREST;
        break;
    case 5:
        minfiltertype = GL_LINEAR_MIPMAP_LINEAR;
        break;
    }

    switch (magfilter)
    {
    case 0:
        magfiltertype = GL_NEAREST;
        break;
    case 1:
        magfiltertype = GL_LINEAR;
        break;
    }

    if (patchfilter)
        filtertype = GL_LINEAR;
    else
        filtertype = GL_NEAREST;
    
	playpal = W_CacheLumpName("PLAYPAL", PU_STATIC);

	size = numlumps * sizeof(*texture_objects);
    texture_objects = malloc (size);
	memset (texture_objects, 0xFF, size); // @texture object number0g邱Ƃ͖̂ŁA-1ł͂Ȃ0gׂ

	nummpnames = sizeof(mpnames)/sizeof(mpnames[0]);
	for (i=0 ; i<nummpnames ; i++)
	{
		lump = W_CheckNumForName(mpnames[i]);
		if (lump < 0)
			continue; // @IWADɂĖpatch
        templumpnum = lump;
		texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
		if ((signed int)texture == -1)
			I_Error("V_Init: texture object number 0xFFF...F is used");
		texture_objects[lump] = texture;
	}

	j = HU_FONTSTART;
    for (i=0;i<HU_FONTSIZE;i++)
    {
		sprintf(buffer, "STCFN%.3d", j++);
		lump = W_CheckNumForName(buffer);
        templumpnum = lump;
		texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
		if ((signed int)texture == -1)
			I_Error("V_Init: texture object number 0xFFF...F is used");
		texture_objects[lump] = texture;
	}

    // @intermissionŎgpatcḧꕔ
    if (gamemode == commercial)
    {
        for (i=0 ; i<32/*NUMCMAPS*/ ; i++)
	    {								
	        sprintf(name, "CWILV%2.2d", i);
            lump = W_CheckNumForName(name);
            if (lump < 0)
			    continue;
            templumpnum = lump;
	        texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
            if ((signed int)texture == -1)
			    I_Error("V_Init: texture object number 0xFFF...F is used");
		    texture_objects[lump] = texture;
	    }					
    }
    else
    {
        int epsd;

        for (epsd=0 ; epsd<3 ; epsd++)
        {
	        for (i=0 ; i<9/*NUMMAPS*/ ; i++)
	        {
	            sprintf(name, "WILV%d%d", epsd, i);
                lump = W_CheckNumForName(name);
                if (lump < 0)
			        continue;
                templumpnum = lump;
	            texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
                if ((signed int)texture == -1)
			        I_Error("V_Init: texture object number 0xFFF...F is used");
		        texture_objects[lump] = texture;
	        }

            for (j=0 ; j<10/*NUMANIMS[wbs->epsd]*/ ; j++)
                for (i=0 ; i<3/*a->nanims*/ ; i++)
                {
                    sprintf(name, "WIA%d%.2d%.2d", epsd, j, i);
                    lump = W_CheckNumForName(name);
                    if (lump < 0)
			            continue;
                    templumpnum = lump;
	                texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
                    if ((signed int)texture == -1)
			            I_Error("V_Init: texture object number 0xFFF...F is used");
		            texture_objects[lump] = texture;
                }
        }
    }
    for (i=0;i<10;i++)
    {
	    // numbers 0-9
	    sprintf(name, "WINUM%d", i);
        lump = W_CheckNumForName(name);
        templumpnum = lump;
		texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_STATIC), filtertype, filtertype);
		if ((signed int)texture == -1)
			I_Error("V_Init: texture object number 0xFFF...F is used");
		texture_objects[lump] = texture;
    }

    if (1)
    {
        unsigned* data;
        int width, height;
        HRSRC hRes;
        HGLOBAL hGlobal;
        int resSize;
        short* resData;

        //data = BitmapResourceToRGBA(L"facehealthbg", &width, &height);
        hRes = FindResource(hInst, "facehealthbg", "IMAGEFILE");
        resSize = SizeofResource(hInst, hRes);
        hGlobal = LoadResource(hInst, hRes);
        resData = LockResource(hGlobal);
        if (*resData == 0x5089/*PNG*/)
        {
            data = ImageFileToRGBA((void*)resData, resSize, &width, &height);
        glGenTextures(1, &facehealthbg);
	    glBindTexture(GL_TEXTURE_2D, facehealthbg);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        }

        //data = BitmapResourceToRGBA(L"armorkeybg", &width, &height);
        hRes = FindResource(hInst, "armorkeybg", "IMAGEFILE");
        resSize = SizeofResource(hInst, hRes);
        hGlobal = LoadResource(hInst, hRes);
        resData = LockResource(hGlobal);
        if (*resData == 0x5089/*PNG*/)
        {
            data = ImageFileToRGBA((void*)resData, resSize, &width, &height);
        glGenTextures(1, &armorkeybg);
	    glBindTexture(GL_TEXTURE_2D, armorkeybg);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        }

        //data = BitmapResourceToRGBA(L"readyarmsbg", &width, &height);
        hRes = FindResource(hInst, "readyarmsbg", "IMAGEFILE");
        resSize = SizeofResource(hInst, hRes);
        hGlobal = LoadResource(hInst, hRes);
        resData = LockResource(hGlobal);
        if (*resData == 0x5089/*PNG*/)
        {
            data = ImageFileToRGBA((void*)resData, resSize, &width, &height);
        glGenTextures(1, &readyarmsbg);
	    glBindTexture(GL_TEXTURE_2D, readyarmsbg);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        }

        //data = BitmapResourceToRGBA(L"ammobg", &width, &height);
        hRes = FindResource(hInst, "ammobg", "IMAGEFILE");
        resSize = SizeofResource(hInst, hRes);
        hGlobal = LoadResource(hInst, hRes);
        resData = LockResource(hGlobal);
        if (*resData == 0x5089/*PNG*/)
        {
            data = ImageFileToRGBA((void*)resData, resSize, &width, &height);
        glGenTextures(1, &ammobg);
	    glBindTexture(GL_TEXTURE_2D, ammobg);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        }
/*
        data = IconResourceToRGBA("redcross", &width, &height);
        glGenTextures(1, &redcross);
	    glBindTexture(GL_TEXTURE_2D, redcross);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);

        resSize = SizeofResource(hInst, FindResource(hInst, "shield", "IMAGEFILE"));
        hRes = LoadResource(hInst, FindResource(hInst, "shield", "IMAGEFILE"));
        resData = LockResource(hRes);
        if (*resData == 0x5089)//PNG
        {
            data = ImageFileToRGBA((void*)resData, resSize, &width, &height);
            glGenTextures(1, &shield);
	        glBindTexture(GL_TEXTURE_2D, shield);
	        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
            glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        }*/
    }

    p = M_CheckParm ("-zlight");
    if (p && p < myargc-1)
        zlighton = atoi(myargv[p+1]);
    glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB, &numunits);
    if (numunits < 2)
        zlighton = 0;
    if (zlighton)
    {
        unsigned* data;
        int width, height;
        GLfloat bordercolor[4] = { 0.5f, 0.5f, 0.5f, 1.0f }; // @ATIñ`bvŃ{[_[J[w肵ȂCLAMPɂȂȂ(GL_CLAMP_TO_EDGEgׂ)
        //GLfloat bordercolor[4] = { 0.33f, 0.33f, 0.33f, 1.0f };

        //zlightrange = 640.0f;
        zlightrange = 1000.0f;
        data = BitmapResourceToRGBA(L"lightmap", &width, &height);
        glGenTextures(1, &zlightmap);
	    glBindTexture(GL_TEXTURE_2D, zlightmap);
        glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, bordercolor);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        free(data);

        glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB");
        glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)wglGetProcAddress("glMultiTexCoord2fARB");
        glActiveTextureARB(GL_TEXTURE1_ARB);
        glEnable(GL_TEXTURE_2D); // @ unit 1 ̓ftHgł͗LɂȂĂȂ
        glActiveTextureARB(GL_TEXTURE0_ARB); // @glTexCoord()glMultiTexCoord() unit 0 w肵Ɠ
    }

    p = M_CheckParm("-shadow");
    if (p && p < myargc-1)
        shadow = atoi(myargv[p+1]);
    if (shadow)
    {
        shadow_textures = malloc(size);
        memset(shadow_textures, 0, size);
    }

    customsky = 1;
    if (customsky)
    {
        unsigned short* id;
        unsigned* data;
        int width, height;
        int border=0;

        for (i=0 ; i<4 ; i++)
        {
            for (j=0 ; j<4 ; j++)
            {
                wsprintf(name, "sky%d_%d", i+1, j);
                lump = W_CheckNumForName(name);
                if (lump < 0)
			        break;
                id = W_CacheLumpNum(lump, PU_CACHE);
                if (  *id == 0x5089 ||  // PNG
                      *id == 0xD8FF ||  // JPG
                      *id == 0x4947 ||  // GIF
                      *id == 0x4D42     // BMP
                   )
                {
                    data = ImageFileToRGBA((void*)id, W_LumpLength(lump), &width, &height);
                    if (texborder)
                    {
                        data = AddBorderToImage(data, width, height, 1);
                        width += 2;
                        height += 2;
                        border = 1;
                        filtertype = magfiltertype;
                    }
                    else
                        filtertype = GL_NEAREST;
                    data = FillBlankPixelsWithAdjacentColors(data, width, height);
                    glGenTextures(1, &texture);
	                glBindTexture(GL_TEXTURE_2D, texture);
	                glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, filtertype);
	                glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, filtertype);
	                glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
                    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
                    glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, border, GL_RGBA, GL_UNSIGNED_BYTE, data);
                    sky_textures[i][j] = texture;
                    free(data);
                }
            }
        }
    }
}

GLuint CreateTexureObjectFromFlat(byte* flat)
{
    int     i;
    byte    dest[4096][4];
    int     index;
    GLuint  texture;
    unsigned* data;
    int width, height;

    i = W_CheckNumForName(lumpinfo[templumpnum].name);
    if (i != -1 && i >= iwadnumlumps &&
        *(short*)flat == 0x5089 ||  // PNG
        *(unsigned short*)flat == 0xD8FF ||  // JPG
        *(short*)flat == 0x4947 ||  // GIF
        *(short*)flat == 0x4D42     // BMP
       )
    {
        data = ImageFileToRGBA((void*)flat, W_LumpLength(templumpnum), &width, &height);
    }
    else
    {
        for (i=0 ; i<4096 ; i++)
        {
            index = flat[i];
            dest[i][0] = playpal[index*3];
            dest[i][1] = playpal[index*3+1];
            dest[i][2] = playpal[index*3+2];
            dest[i][3] = 255;
        }
        width = 64;
        height = 64;
        data = (void*)&dest[0][0];
    }

    glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, minfiltertype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, magfiltertype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    if (minfiltertype == GL_LINEAR || minfiltertype == GL_NEAREST)
	    glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
    else
        gluBuild2DMipmaps(GL_TEXTURE_2D, 4, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);

    return texture;
}

void CacheFlatTextureObject(int lump)
{
    GLuint	texture;

    if ((int)(texture_objects[lump]) != -1)
        return;

    templumpnum = lump;
    texture = CreateTexureObjectFromFlat( W_CacheLumpNum(lump, PU_CACHE) );
	if ((signed int)texture == -1)
		I_Error("CacheFlatTextureObject: texture object number 0xFFF...F is used");
	texture_objects[lump] = texture;
}

void ReleaseTextureObject(int lump)
{
    if ((int)(texture_objects[lump]) == -1)
        return;

    glDeleteTextures(1, &texture_objects[lump]);
    texture_objects[lump] = -1;
}

extern texture_t**      textures;
extern unsigned int*    gltextures;

void CacheWallTextureObject(int texnum)
{
    int			width, height, scaled_width, scaled_height;
	unsigned	*data, *scaled_data;
    GLuint      texobject;
    texture_t*  texture;
    texpatch_t* texpatch;
    patch_t*    patch;
    post_t*     column;
    int         i, x1, x2, x;
    unsigned short* id;

    if ((int)(gltextures[texnum]) != -1)
        return;

    texture = textures[texnum];

    i = W_CheckNumForName(texture->name);
    if (i != -1 && i >= iwadnumlumps)
    {
        id = W_CacheLumpNum(i, PU_CACHE);
        if (  *id == 0x5089 ||  // PNG
              *id == 0xD8FF ||  // JPG
              *id == 0x4947 ||  // GIF
              *id == 0x4D42     // BMP
           )
        {
            data = ImageFileToRGBA((void*)id, W_LumpLength(i), &width, &height);
            goto next;
        }
    }

    width = texture->width;
    height = texture->height;
    data = calloc(width*height, 4);

    texpatch = texture->patches;
    for (i=0 ; i<texture->patchcount ; i++, texpatch++)
    {
        patch = W_CacheLumpNum(texpatch->patch, PU_CACHE);
        x1 = texpatch->originx;
        x2 = x1 + patch->width;

        if (x1 < 0)
            x = 0;
        else
            x = x1;

        if (x2 > width)
            x2 = width;

        for ( ; x<x2 ; x++)
        {
            column = (post_t *)((byte *)patch + patch->columnofs[x - x1]);
            DrawColumnInRGBA(column, (byte *)data, x, texpatch->originy, width, height);
        }
    }

    if (glvers >= 2)
        goto next;

    for (scaled_width=1 ; scaled_width<width ; scaled_width<<=1)
		;
	for (scaled_height=1 ; scaled_height<height ; scaled_height<<=1)
		;

	if (width != scaled_width || height != scaled_height)
	{
		scaled_data = calloc(scaled_width*scaled_height, 4);
		ResampleTexture(data, width, height, scaled_data, scaled_width, scaled_height);
		free(data);
		data = scaled_data;
        width = scaled_width;
        height = scaled_height;
	}

next:
	glGenTextures(1, &texobject);
	glBindTexture(GL_TEXTURE_2D, texobject);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, minfiltertype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, magfiltertype);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	if (minfiltertype == GL_LINEAR || minfiltertype == GL_NEAREST)
	    glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
    else
        gluBuild2DMipmaps(GL_TEXTURE_2D, 4, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);

	free(data);

    if ((signed int)texobject == -1)
		I_Error("CacheWallTextureObject: texture object number 0xFFF...F is used");

    gltextures[texnum] = texobject;
}

void ReleaseWallTextureObject(int texnum)
{
    if ((int)(gltextures[texnum]) == -1)
        return;

    glDeleteTextures(1, &gltextures[texnum]);
    gltextures[texnum] = -1;
}

void CacheSpriteTextureObject(int lump)
{
    GLuint	texture;
    GLenum  filtertype;

    if ((int)(texture_objects[lump]) != -1)
    {
        I_Debug("CacheSpriteTextureObject: already cached\n");
        return;
    }

    if (spritefilter)
        filtertype = GL_LINEAR;
    else
        filtertype = GL_NEAREST;

    templumpnum = lump;
    texture = CreateTexureObjectFromPatch(W_CacheLumpNum(lump, PU_CACHE), filtertype, filtertype);
	if ((signed int)texture == -1)
		I_Error("CacheSpriteTextureObject: texture object number 0xFFF...F is used");
	texture_objects[lump] = texture;

    if (shadow)
    {
        patch_t* patch = W_CacheLumpNum(lump, PU_CACHE);
        int width;
	    int height;
        //int width2 = width/2;
        //int height2 = height/2;
	    unsigned* data;
        //unsigned* data2 = calloc(width2*height2*4, 1);
        int i, j;
        post_t* column;
        //byte *src, *dest;
        byte* data_p;

        if (  *(short*)patch == 0x5089 ||  // PNG
              *(unsigned short*)patch == 0xD8FF ||  // JPG
              *(short*)patch == 0x4947 ||  // GIF
              *(short*)patch == 0x4D42     // BMP
           )
        {
            data = ImageFileToRGBA((void*)patch, W_LumpLength(lump), &width, &height);
        }
        else
        {
        width = SHORT(patch->width);
        height = SHORT(patch->height);
        data = calloc(width*height*4, 1);

	    for (i=0 ; i<width ; i++)
	    {
		    column = (post_t *)((byte *)patch + patch->columnofs[i]);
            DrawColumnInRGBA(column, (byte *)data, i, 0, width, height);
        }
        }
/*
        for (i=0 ; i<height2 ; i++)
        {
            src = (byte*)&data[i*width*2];
            dest = (byte*)&data2[i*width2];
            for (j=0 ; j<width2 ; j++, src+=8, dest+=4)
            {
                if (src[3] == 255)
                    dest[3] = 255;
            }
        }
*/
        for (i=0 ; i<height ; i++)
        {
            data_p = (byte*)&data[i*width];
            for (j=0 ; j<width ; j++, data_p+=4)
            {
                data_p[0] = 0;
                data_p[1] = 0;
                data_p[2] = 0;
            }
        }

        glGenTextures(1, &texture);
	    glBindTexture(GL_TEXTURE_2D, texture);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        //glTexImage2D(GL_TEXTURE_2D, 0, 4, width2, height2, 0, GL_RGBA, GL_UNSIGNED_BYTE, data2);
        glTexImage2D(GL_TEXTURE_2D, 0, 4, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);

        shadow_textures[lump] = texture;

        free(data);
        //free(data2);
    }
}
