from email import message
from itertools import count
import random
from re import X
from struct import pack
import tkinter as tk
from tkinter import ttk
from tkinter import messagebox
from PIL import Image, ImageTk
import data

# 答え
ans = 0
# カウンタ
counter = 0
# 入力値
neko_weight = 0

def initialize():
    '''
    初期化
    '''
    global ans
    global counter
    global neko_weight

    # 答え
    max = 2**7
    print(f"{max}")
    ans = random.randint(1, max)
    print(f"{ans}")
    # カウンタ
    counter = 0
    # 入力値
    neko_weight = 0
    return

def initialize_neko():
    '''
    ねこ画像初期化
    '''
    for index, item in enumerate(data.item_info):
        item['enable'] = True

    canvas.lift('base')
    canvas.lift('tower')
    canvas.lift('neko')
    return

def show_answerneko():
    '''
    解答表示
    '''
    for index, item in enumerate(data.item_info):
        if item['enable'] == False:
            canvas.lift(answerneko_id[index], towerId[1])
    return

def move_neko(event):
    '''
    ねこ移動
    '''
    global neko_id
    global neko_weight
    global towerneko_id
    global towerId
    # マウスカーソルの位置に一番近い図形のIDのタプルを取得
    closest_ids = canvas.find_closest(event.x, event.y)
    index = neko_id.index(closest_ids[0])
    print(f'id : {closest_ids}')
    print(f'neko_id {index}')
    data.item_info[index]['enable'] = False
    event.widget.lift(towerneko_id[index], towerId[0])
    event.widget.lift(base_id[index], neko_id[index])
    neko_weight += data.item_info[index]['weight']
    print(f'neko_weight {neko_weight}')
    return

def return_neko(event):
    '''
    ねこ移動
    '''
    global base_id
    global neko_id
    global neko_weight
    global towerneko_id
    global towerId
    # マウスカーソルの位置に一番近い図形のIDのタプルを取得
    closest_ids = canvas.find_closest(event.x, event.y)
    index = towerneko_id.index(closest_ids[0])
    print(f'id : {closest_ids}')
    print(f'towerneko_id {index}')
    data.item_info[index]['enable'] = True
    event.widget.lower(towerneko_id[index], towerId[0])
    event.widget.lift(neko_id[index], base_id[index])
    neko_weight -= data.item_info[index]['weight']
    print(f'neko_weight {neko_weight}')
    return

def move_tower(diff):
    '''
    ねこタワー移動
    '''
    canvas.move(towerId[0], 0, -diff)
    canvas.move('towerneko', 0, -diff)
    canvas.move(towerId[1], 0, diff)
    canvas.move('answerneko', 0, diff)
    return

def return_tower(diff):
    '''
    ねこタワー正位置へ
    '''
    canvas.move(towerId[0], 0, diff)
    canvas.move('towerneko', 0, diff)
    canvas.move(towerId[1], 0, -diff)
    canvas.move('answerneko', 0, -diff)
    return

def check_weight():
    '''
    計測実行
    '''
    global canvas
    global counter
    global neko_weight
    global ans
    counter += 1
    diff = ans - neko_weight
    print(f"counter={counter} neko_weight={neko_weight} answer={ans}")
    if diff == 0:
        show_answerneko()
        messagebox.showinfo('終了', f'{counter}回目です。正解！')
        initialize()
        initialize_neko()
    else:
        move_tower(diff)
        if diff > 0:
            message = '軽い'
        else:
            message = '重い'
        messagebox.showinfo('判定', f'{counter}回目です。{message}')
        return_tower(diff)
    return


#version = tk.Tcl().eval('info patchlevel')

root = tk.Tk()
root.title(f'ねこばかり')
root.geometry('480x480')
#root.geometry('640x480')

# 画像表示
neko = []
for index, fname in enumerate(data.item_info):
    if index > 0:
        data.item_info[index]['x'] = data.item_info[index-1]['x'] + data.item_info[index-1]['width'] + 4
        data.item_info[index]['y'] = data.item_info[index-1]['y'] + 6

    img = Image.open(fname['file'])
    size = [fname['width'], fname['height']] 
    img = img.resize(size=size)
    img = ImageTk.PhotoImage(img)
    neko.append(img)

tower = []
for index, fname in enumerate(data.tower_info):
    img = Image.open(fname['file'])
    img = ImageTk.PhotoImage(img)
    tower.append(img)

# Canvasの作成
canvas = tk.Canvas(bg='wheat1', width=476, height=476)
canvas.place(x=0, y=0)

base_id = []
for index, item in enumerate(data.item_info):
    base_id.append(canvas.create_rectangle( 
                        item['x'], item['y'], 
                        item['x']+item['width'], 
                        item['y']+item['height'],  
                        fill='wheat2', width = 0, tag="base"))

neko_id = []
for index, pic in enumerate(neko):
    neko_id.append(canvas.create_image(
                        data.item_info[index]['x'], 
                        data.item_info[index]['y'], 
                        image=pic, anchor=tk.NW, tag='neko'))
canvas.tag_bind('neko', '<ButtonPress>', move_neko)

towerneko_id = []
for index, pic in enumerate(neko):
    towerneko_id.append(canvas.create_image(
                        data.item_info[index]['cagex'], 
                        data.item_info[index]['cagey'], 
                        image=pic, anchor=tk.NW, tag='towerneko'))
canvas.tag_bind('towerneko', '<ButtonPress>', return_neko)

answerneko_id = []
for index, pic in enumerate(neko):
    answerneko_id.append(canvas.create_image(
                        data.item_info[index]['cagex'] + 240,
                        data.item_info[index]['cagey'], 
                        image=pic, anchor=tk.NW, tag='answerneko'))

towerId = []
for index, pic in enumerate(tower):
    towerId.append(canvas.create_image(
                        data.tower_info[index]['x'], 
                        data.tower_info[index]['y'], 
                        image=pic, anchor=tk.NW, tag='tower'))

'''
start_x = tk.StringVar()
start_y = tk.StringVar()
current_x = tk.StringVar()
current_y = tk.StringVar()
stop_x = tk.StringVar()
stop_y = tk.StringVar()

label_description = ttk.Label(root, text='Mouse position')
label_description.grid(row=0, column=1)
label_start_x = ttk.Label(root, textvariable=start_x)
label_start_x.grid(row=1, column=1)
label_start_y = ttk.Label(root, textvariable=start_y)
label_start_y.grid(row=2, column=1)
label_current_x = ttk.Label(root, textvariable=current_x)
label_current_x.grid(row=3, column=1)
label_current_y = ttk.Label(root, textvariable=current_y)
label_current_y.grid(row=4, column=1)
label_stop_x = ttk.Label(root, textvariable=stop_x)
label_stop_x.grid(row=5, column=1)
label_stop_y = ttk.Label(root, textvariable=stop_y)
label_stop_y.grid(row=6, column=1)
'''

canvas.grid(row=0, column=0, rowspan=7)

btn = tk.Button(root,
            text='計測開始',
            command=check_weight)
btn.grid(row=3,column=0)

initialize()
root.mainloop()
