//ǂƃ}XɃio[U莯
//NX^OpHASY
//f[^邾ŁA\͂܂ʂ̃vO

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "BitmapHeader.h"

//indexɂėאڂ}X̃io[߂
#define LEFT(index) ( (index / (width-1)) * width + (index % (width-1)) )
#define RIGHT(index) ( LEFT(index) + 1 )
#define TOP(index) ( index )
#define BOTTOM(index) ( index + width)

//̐Fƕǂ̐F
#define ROADCOLOR 255
#define WALLCOLOR 0



//O[oϐ
unsigned long* mass;			//}X
int* vPartitions;	//c̕ǂ݂邩̃tO@1ő݁A0Ŕjς
int* hPartitions;	//̕ǂ݂邩̃tO@1ő݁A0Ŕjς
unsigned long* breakableTable;//j\ȕǂi[e[u
unsigned long tableSize;		//breakableTable̗LTCY
unsigned long* pixelIndexTable;

//H̏cƉ(}X̐)
int width = -1;
int height = -1;

//ƕǕ(px)
int roadWidth;
int wallWidth;
int massWidth;

//o͉摜̃sNZƍ
int pixelWidth;
int pixelHeight;
//paddinglrbg}bvf[^ł̕
int bitmapDataWidth;

//evf̐
unsigned long massNum;
unsigned long vPartNum;
unsigned long hPartNum;


//vg^Cv錾
int initializeProcess(void);
void mainProcess(void);
//j\ȕǂ̃CfbNX擾
unsigned long getBreakablePartition(void);
//2̃}Xio[1ɓꂷ
void integrateMasses(unsigned long, unsigned long);
//j\ȕǂ̃CfbNXꗗXV
void refreshBreakableTable(void);
void saveResult(void);
void toTextData(char*);
void toBmpData(char*);
//ވʒuƕ\sNZ̑Ή\
void makePixelIndexTable(void);
//8bitrbg}bvƂăwb_[
void writeHeaderToBinary(FILE*);
//8bitrbg}bvƂăJ[pbg
void writeColorPaletteToBinary(FILE*);
//8bitrbg}bvƂăJ[f[^
void writeColorDataToBinary(FILE*);
//indexǉsNZ̐F擾
unsigned char getPixelColor(unsigned long);
//ȊO̔@Ȃ1,ȊOȂ0
int isRoad(unsigned long);
//sNZ̃CfbNX擾
unsigned long getPixelIndex(unsigned long);
//ǂǂ̕Ԃ@E(0,1,2,3)
int getWallDirection(int, int , int, int);
//}Xƕǂ̕Aǂ̃f[^邩ۂԂ
int isExistence(unsigned long, int);
////}Xƕǂ̕Aǂ󂳂Ă邩ۂԂ
int isBroken(unsigned long, int);
void endProcess(void);


int main(void){
	initializeProcess();
	mainProcess();
	saveResult();
	
	endProcess();

	return 0;
}

int initializeProcess(void){
	unsigned long i;

	printf("H̏c͂Ă:");	scanf("%d",&height);
	printf("H̉͂Ă:");	scanf("%d",&width);
	
	if((width < 2) || (height < 2)){
		return -1;
	}
	
	srand((unsigned)time(NULL));
	
	massNum = width * height;
	vPartNum = (width-1) * height;
	hPartNum = width * (height-1);
	tableSize = vPartNum + hPartNum;
	
	mass = (unsigned long*)malloc(sizeof(unsigned long) * massNum);
	vPartitions = (int*)malloc(sizeof(int) * vPartNum);
	hPartitions = (int*)malloc(sizeof(int) * hPartNum);
	breakableTable = (unsigned long*)malloc(sizeof(unsigned long) * tableSize);
	
	for(i=0; i< massNum; i++){
		mass[i] = i;
	}
	for(i=0; i< vPartNum; i++){
		vPartitions[i] = 1;
	}
	for(i=0; i< hPartNum; i++){
		hPartitions[i] = 1;
	}
	for(i=0; i< tableSize; i++){
		breakableTable[i] = i;
	}
	
	return 0;
}

void mainProcess(void){
	//step1 j\ȕǂI
	//step2 j\ȕǂȂꍇI
	//step3 j\ȕǂꍇ͔j󂷂
	//step4 Ȃ}X̃io[ɓꂷ
	//step5 ǂ󂵂j\ȕǈꗗXV

	unsigned long endCounter = 0;

	printf("vZ...\n");
	do{
		unsigned long num1, num2;

		//step1
		unsigned long breakablePartition = getBreakablePartition();

		//step2
		if(breakablePartition < 0){
			break;
		}

		//step3
		if(breakablePartition < vPartNum){
			//ǂc̏ꍇ
			vPartitions[breakablePartition] = 0;
			num1 = mass[LEFT(breakablePartition)];
			num2 = mass[RIGHT(breakablePartition)];
		}else if(breakablePartition < (vPartNum + hPartNum)){
			//ǂ̏ꍇ
			hPartitions[breakablePartition - vPartNum] = 0;
			num1 = mass[TOP(breakablePartition - vPartNum)];
			num2 = mass[BOTTOM(breakablePartition - vPartNum)];
		}else{
			break;
		}

		//step4
		integrateMasses(num1, num2);
		refreshBreakableTable();

	}while( (endCounter++) <= (vPartNum + hPartNum) );

	printf("vZI...\n");
}

unsigned long getBreakablePartition(void){
	unsigned long nRes[2];
	
	//j\ȕǂȂꍇ
	if(tableSize == 0){
		return -1;
	}

	

	nRes[0] = rand() << 4;
	nRes[1] = rand();
	nRes[0] |= nRes[1] & 0x0F;

	return breakableTable[nRes[0] % tableSize];
}

void refreshBreakableTable(void){
	unsigned long i;
	int addFlag;
	unsigned long* newBreakableTable;
	unsigned long newTableSize = 0;

	newBreakableTable = (unsigned long*)malloc(sizeof(unsigned long)*tableSize);

	for(i=0;i<tableSize;i++){
		unsigned long checkPart = breakableTable[i];
		addFlag = 0;
		newBreakableTable[i] = 0;

		//ǂc𔻕
		if(checkPart < vPartNum){
			//ǂĉƂ
			if( vPartitions[checkPart] ){
				unsigned long lIndex = LEFT(checkPart);
				unsigned long rIndex = RIGHT(checkPart);
				unsigned long lNumber = mass[lIndex];
				unsigned long rNumber = mass[rIndex];

				addFlag = 1;
				
				if(lNumber == rNumber){
					addFlag = 0;
				}
			}
		}else{
			if( hPartitions[checkPart - vPartNum] ){
				//ǂ̂Ƃ
				unsigned long tIndex = TOP(checkPart - vPartNum);
				unsigned long bIndex = BOTTOM(checkPart - vPartNum);
				unsigned long tNumber = mass[tIndex];
				unsigned long bNumber = mass[bIndex];

				addFlag = 1;

				if(tNumber == bNumber){
					addFlag = 0;
				}
			}
		}

		//j\ȕǂȂǉ
		if(addFlag == 1){
			newBreakableTable[newTableSize] = breakableTable[i];
			newTableSize++;
		}
	}

	//XV𔽉f
	for(i=0;i<tableSize;i++){
		breakableTable[i] = newBreakableTable[i];
		
	}

	tableSize = newTableSize;

	free(newBreakableTable);
}

void integrateMasses(unsigned long num1, unsigned long num2){
	unsigned long min = (num1 < num2) ? num1: num2;
	unsigned long max = (num1 > num2) ? num1: num2;
	unsigned long i;

	for(i=0;i<massNum;i++){
		if(mass[i] == max){
			mass[i] = min;
		}
	}
}

void saveResult(void){
	int saveFlag = 0;
	char filename[256] = "";
	int endFlag = 0;
	
	printf("ۑt@C͂ĂB\n");
	scanf("%255s", filename);

	do{
		printf("ۑ`IĂB\n"
			"PeLXgf[^ɕۑ\n"
			"Q摜f[^ŕۑ\n"
			"ReLXgf[^Ɖ摜f[^ŕۑ\n");
		scanf("%d", &saveFlag);

		if(saveFlag == 1){
			toTextData(filename);
			endFlag = 1;
		}else if(saveFlag == 2){
			toBmpData(filename);
			endFlag = 1;
		}else if(saveFlag == 3){
			toTextData(filename);
			toBmpData(filename);
			endFlag = 1;
		}else{
			printf("w肳ꂽl͂Ă\n");
		}
	}while(endFlag == 0);
}

void toTextData(char* filename){
	FILE *result;
	unsigned long i;
	char bufFilename[256]="";

	strcpy(bufFilename, filename);

	if((result = fopen(strcat(bufFilename, ".txt"), "w")) == NULL) {
		printf("t@C쐬ł܂!\n");
		exit(1);
	}else{
		fprintf(result, "%d\n%d\n", width, height);

		for(i=0;i<vPartNum;i++){
			fprintf(result, "%d\n", vPartitions[i]);
		}
		for(i=0;i<hPartNum;i++){
			fprintf(result, "%d\n", hPartitions[i]);
		}
		fclose(result);
	}
}

void toBmpData(char* filename){
	FILE *fp;
	roadWidth = 5;
	wallWidth = 1;
	massWidth = (roadWidth + wallWidth*2);
	char bufFilename[256]="";
	
	
	pixelWidth = massWidth * width;
	if((pixelWidth % 4) != 0){
		bitmapDataWidth = 4 * ((pixelWidth / 4) + 1);
	}else{
		bitmapDataWidth = pixelWidth;
	}
	pixelHeight = massWidth * height;
	pixelIndexTable = (unsigned long*)malloc(sizeof(unsigned long) * bitmapDataWidth * pixelHeight);
	makePixelIndexTable();

	strcpy(bufFilename, filename);

	if((fp = fopen(strcat(bufFilename, ".bmp"), "wb")) == NULL) {
		printf("t@C쐬ł܂!\n");
		exit(1);
	}else{
		//8bitrbg}bvƂăwb_[
		writeHeaderToBinary(fp);
		//8bitrbg}bvƂăJ[pbg
		writeColorPaletteToBinary(fp);
		//8bitrbg}bvƂăJ[f[^
		writeColorDataToBinary(fp);
		
		fclose(fp);
	}
}

void makePixelIndexTable(void){
	int i, j;

	for(i=0;i<pixelHeight;i++){
		for(j=0;j<bitmapDataWidth;j++){
			pixelIndexTable[i*bitmapDataWidth + j] = (pixelHeight - i - 1) * bitmapDataWidth + j;
		}
	}
}

void writeHeaderToBinary(FILE *fp){
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	unsigned long bfSize;
	unsigned long biSizeImage;

	biSizeImage = bitmapDataWidth * pixelHeight;
	bfSize = 1078 + biSizeImage;

	//BITMAPFILEHEADER̐ݒ
	bmfh.bfType = 19778;
	bmfh.bfSize = bfSize;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = 1078;

	//BITMAPINFOHEADER̐ݒ
	bmih.biSize = 40;
	bmih.biWidth = pixelWidth;
	bmih.biHeight = pixelHeight;
	bmih.biPlanes = 1;
	bmih.biBitCount = 8;
	bmih.biCompression = 0;
	bmih.biSizeImage = biSizeImage;
	bmih.biXPixPerMeter = 0;
	bmih.biYPixPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImporant = 0;

	//BITMAPFILEHEADEȐ
	fwrite(&bmfh.bfType, 2, 1, fp);
	fwrite(&bmfh.bfSize, 4, 1, fp);
	fwrite(&bmfh.bfReserved1, 2, 1, fp);
	fwrite(&bmfh.bfReserved2, 2, 1, fp);
	fwrite(&bmfh.bfOffBits, 4, 1, fp);

	//BITMAPINFOHEADEȐ
	fwrite(&bmih.biSize, 4, 1, fp);
	fwrite(&bmih.biWidth, 4, 1, fp);
	fwrite(&bmih.biHeight, 4, 1, fp);
	fwrite(&bmih.biPlanes, 2, 1, fp);
	fwrite(&bmih.biBitCount, 2, 1, fp);
	fwrite(&bmih.biCompression, 4, 1, fp);
	fwrite(&bmih.biSizeImage, 4, 1, fp);
	fwrite(&bmih.biXPixPerMeter, 4, 1, fp);
	fwrite(&bmih.biYPixPerMeter, 4, 1, fp);
	fwrite(&bmih.biClrUsed, 4, 1, fp);
	fwrite(&bmih.biClrImporant, 4, 1, fp);
}

void writeColorPaletteToBinary(FILE* fp){
	FILE* read;
	int i;

	if((read = fopen("colorPalette.bin", "rb")) == NULL) {
		printf("ݒt@CcolorPalette.bin܂!\n");
		exit(1);
	}

	for(i=0;i<1024;i++){
		unsigned char buffer;
		fread(&buffer, 1, 1, read);
		fwrite(&buffer, 1, 1, fp);
	}

	fclose(read);
}

void writeColorDataToBinary(FILE *fp){
	unsigned long i;
	unsigned long end = (unsigned long)bitmapDataWidth * (unsigned long)pixelHeight;
	//sNZ[vt@C1Byte(PF)ł
	for(i=0;i<end;i++){
		unsigned char buffer = getPixelColor(i);
		fwrite(&buffer, 1, 1, fp);
	}
}

unsigned char getPixelColor(unsigned long index){
	unsigned char pxColor = 0;

	if(isRoad(index) == 1){
		pxColor = ROADCOLOR;
	}else{
		pxColor = WALLCOLOR;
	}

	return pxColor;
}

int isRoad(unsigned long index){
	unsigned long pxIndex;
	int pxX, pxY;		//ΏۃsNZ̍W
	int massX, massY;	//}X̍W
	int wallDirection;
	unsigned long massIndex;

	pxIndex = getPixelIndex(index);

	pxX = pxIndex % bitmapDataWidth;
	pxY = pxIndex / bitmapDataWidth;

	if(pxX >= pixelWidth){
		//sNZXW摜͈̔͊O̎(pfBÖ)
		return 0;
	}

	massX = pxX / massWidth;
	massY = pxY / massWidth;

	massIndex = massY * width + massX;
	wallDirection = getWallDirection(pxX, pxY, massX, massY);

	if(wallDirection < 0){
		//
		return 1;
	}else if(wallDirection >= 0 && wallDirection <= 3){
		if(isExistence(massIndex, wallDirection) == 0){
			//Ǐ񂪂ȂiOg̎j
			return 0;
		}else{
			//Ǐ񂪂
			//j󂳂Ă邩ĂȂ`FbN
			if(isBroken(massIndex, wallDirection) == 1){
				//j󂳂Ă
				return 1;
			}else{
				return 0;
			}
		}
	}else{
		//ǂƕǂԂƂ
		return 0;
	}
}

unsigned long getPixelIndex(unsigned long index){
	return pixelIndexTable[index];
}

int getWallDirection(int pxX, int pxY, int massX, int massY){
	int flag = 0;
	
	//}X̍Wo(΍W)
	pxX = pxX - massX * massWidth;
	pxY = pxY - massY * massWidth;

	if(pxX < wallWidth){
		//
		flag += 1;
	}
	
	if(pxX > (wallWidth + roadWidth - 1)){
		//E
		flag += 2;
	}
	
	if(pxY < wallWidth){
		//
		flag += 4;
	}
	
	if(pxY > (wallWidth + roadWidth -1 )){
		//
		flag += 7;
	}


	switch(flag){
		case 1:
			//
			return 3;
		case 2:
			//E
			return 1;
		case 4:
			//
			return 0;
		case 7:
			//
			return 2;
		case 0:
			//
			return -1;
		default:
			//l̂ǂꂩ
			return 4;
	}
}

int isExistence(unsigned long massIndex, int direction){
	if((massIndex / width) == 0){
		if(direction == 0){
			return 0;
		}
	}
	
	if((massIndex / width) == (height-1)){
		if(direction == 2){
			return 0;
		}
	}
	
	if((massIndex % width) == 0){
		if(direction == 3){
			return 0;
		}
	}
	
	if((massIndex % width) == (width-1)){
		if(direction == 1){
			return 0;
		}
	}

	return 1;
}

int isBroken(unsigned long massIndex, int direction){
	int index;

	if(direction == 0){
		//̕
		index = massIndex - width;

		return !hPartitions[index];
	}else if(direction == 1){
		//E̕
		index = massIndex - (massIndex / width);

		return !vPartitions[index];
	}else if(direction == 2){
		//̕
		index = massIndex;

		return !hPartitions[index];
	}else if(direction == 3){
		//̕
		index = massIndex - (massIndex / width) - 1;

		return !vPartitions[index];
	}

	return -1;
}

void endProcess(void){
	free(mass);
	free(vPartitions);
	free(hPartitions);
	free(breakableTable);
	free(pixelIndexTable);
}